/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import ch.qos.cal10n.IMessageConveyor;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.MessageConveyorFactory;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.cal10n.LocLoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class LoggerFactory {
    private static LoggerFactory INSTANCE = new LoggerFactory("WELD");
    private final LocLoggerFactory locLoggerFactory;
    private final IMessageConveyor messageConveyor;

    private LoggerFactory(String subsystem) {
        this.messageConveyor = MessageConveyorFactory.messageConveyerFactory().getDefaultMessageConveyer(subsystem);
        this.locLoggerFactory = new LocLoggerFactory(this.messageConveyor);
    }

    public LocLogger getLogger(Category category) {
        return this.locLoggerFactory.getLocLogger(category.getName());
    }

    public XLogger getXLogger(Category category) {
        return XLoggerFactory.getXLogger(category.getName());
    }

    public static LoggerFactory loggerFactory() {
        return INSTANCE;
    }

    public IMessageConveyor getMessageConveyor() {
        return this.messageConveyor;
    }
}

