/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ctl;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.ctl.AuthorizationIDResponseControl;
import com.sun.jndi.ldap.ctl.DirSyncResponseControl;
import com.sun.jndi.ldap.ctl.PagedResultsResponseControl;
import com.sun.jndi.ldap.ctl.PasswordExpiredResponseControl;
import com.sun.jndi.ldap.ctl.PasswordExpiringResponseControl;
import com.sun.jndi.ldap.ctl.SortResponseControl;
import com.sun.jndi.ldap.ctl.VirtualListViewResponseControl;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;

public class ResponseControlFactory
extends ControlFactory {
    public Control getControlInstance(Control control) throws NamingException {
        String string = control.getID();
        BasicControl basicControl = null;
        try {
            if (string.equals("1.2.840.113556.1.4.474")) {
                basicControl = new SortResponseControl(string, control.isCritical(), control.getEncodedValue());
            } else if (string.equals("2.16.840.1.113730.3.4.10")) {
                basicControl = new VirtualListViewResponseControl(string, control.isCritical(), control.getEncodedValue());
            } else if (string.equals("1.2.840.113556.1.4.319")) {
                basicControl = new PagedResultsResponseControl(string, control.isCritical(), control.getEncodedValue());
            } else if (string.equals("1.2.840.113556.1.4.841")) {
                basicControl = new DirSyncResponseControl(string, control.isCritical(), control.getEncodedValue());
            } else if (string.equals("2.16.840.1.113730.3.4.4")) {
                basicControl = new PasswordExpiredResponseControl(string, control.isCritical(), control.getEncodedValue());
            } else if (string.equals("2.16.840.1.113730.3.4.5")) {
                basicControl = new PasswordExpiringResponseControl(string, control.isCritical(), control.getEncodedValue());
            } else if (string.equals("2.16.840.1.113730.3.4.15")) {
                basicControl = new AuthorizationIDResponseControl(string, control.isCritical(), control.getEncodedValue());
            }
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
        return basicControl;
    }
}

