/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.spi_impl;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.rx.policy.assertion.AssertionNamespace;
import com.sun.xml.ws.rx.policy.assertion.metro.rm200603.AckRequestIntervalClientAssertion;
import com.sun.xml.ws.rx.policy.assertion.metro.rm200603.AllowDuplicatesAssertion;
import com.sun.xml.ws.rx.policy.assertion.metro.rm200603.CloseTimeoutClientAssertion;
import com.sun.xml.ws.rx.policy.assertion.metro.rm200603.OrderedDeliveryAssertion;
import com.sun.xml.ws.rx.policy.assertion.metro.rm200603.ResendIntervalClientAssertion;
import com.sun.xml.ws.rx.policy.assertion.metro.rm200702.PersistentAssertion;
import com.sun.xml.ws.rx.policy.assertion.net.rm200502.RmFlowControlAssertion;
import com.sun.xml.ws.rx.policy.assertion.net.rm200702.AcknowledgementIntervalAssertion;
import com.sun.xml.ws.rx.policy.assertion.net.rm200702.InactivityTimeoutAssertion;
import com.sun.xml.ws.rx.policy.assertion.wsmc200702.MakeConnectionSupportedAssertion;
import com.sun.xml.ws.rx.policy.assertion.wsrm200502.Rm10Assertion;
import com.sun.xml.ws.rx.policy.assertion.wsrm200702.Rm11Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;

public class RxAssertionValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> SERVER_SIDE_ASSERTIONS = new ArrayList(5);
    private static final ArrayList<QName> CLIENT_SIDE_ASSERTIONS = new ArrayList(8);
    private static final List<String> SUPPORTED_DOMAINS = Collections.unmodifiableList(AssertionNamespace.namespacesList());

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) {
        return CLIENT_SIDE_ASSERTIONS.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) {
        QName assertionName = assertion.getName();
        if (SERVER_SIDE_ASSERTIONS.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (CLIENT_SIDE_ASSERTIONS.contains(assertionName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public String[] declareSupportedDomains() {
        return SUPPORTED_DOMAINS.toArray(new String[SUPPORTED_DOMAINS.size()]);
    }

    static {
        SERVER_SIDE_ASSERTIONS.add(Rm10Assertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(Rm11Assertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(MakeConnectionSupportedAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(OrderedDeliveryAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(AllowDuplicatesAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(RmFlowControlAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(InactivityTimeoutAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(AcknowledgementIntervalAssertion.NAME);
        SERVER_SIDE_ASSERTIONS.add(PersistentAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.add(AckRequestIntervalClientAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.add(ResendIntervalClientAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.add(CloseTimeoutClientAssertion.NAME);
        CLIENT_SIDE_ASSERTIONS.addAll(SERVER_SIDE_ASSERTIONS);
    }
}

