/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-connector-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.connector.resources")
public class ListConnectorResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorResources.class);
    @Inject
    ConnectorResource[] resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (ConnectorResource r : this.resources) {
                list.add(r.getJndiName());
            }
            for (String jndiName : list) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.connector.resources.fail", "List connector resources failed") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

