/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="resource-adapter-config")
@Scoped(value=PerLookup.class)
@I18n(value="create.resource.adapter.config")
public class ResourceAdapterConfigManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceAdapterConfigManager.class);
    private String raName = null;
    private String threadPoolIds = null;
    private String objectType = "user";
    private String name = null;

    public String getResourceType() {
        return "resource-adapter-config";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        this.setParams(attrList);
        if (this.raName == null) {
            String msg = localStrings.getLocalString("create.resource.adapter.confignoRAName", "No RA Name defined for resource adapter config.");
            return new ResourceStatus(1, msg);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof ResourceAdapterConfig) || !((ResourceAdapterConfig)resource).getResourceAdapterName().equals(this.raName)) continue;
            String msg = localStrings.getLocalString("create.resource.adapter.config.duplicate", "Resource adapter config already exists for RAR", new Object[]{this.raName});
            return new ResourceStatus(1, msg);
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ResourceAdapterConfig newResource = (ResourceAdapterConfig)param.createChild(ResourceAdapterConfig.class);
                    newResource.setResourceAdapterName(ResourceAdapterConfigManager.this.raName);
                    if (ResourceAdapterConfigManager.this.threadPoolIds != null) {
                        newResource.setThreadPoolIds(ResourceAdapterConfigManager.this.threadPoolIds);
                    }
                    newResource.setObjectType(ResourceAdapterConfigManager.this.objectType);
                    if (ResourceAdapterConfigManager.this.name != null) {
                        newResource.setName(ResourceAdapterConfigManager.this.name);
                    }
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, resources);
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(ResourceAdapterConfigManager.class.getName()).log(Level.SEVERE, "TransactionFailure: create-resource-adapter-config", tfe);
            String msg = localStrings.getLocalString("create.resource.adapter.config.fail", "Unable to create resource adapter config", new Object[]{this.raName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = localStrings.getLocalString("create.resource.adapter.config.success", "Resource adapter config {0} created successfully", new Object[]{this.raName});
        return new ResourceStatus(0, msg);
    }

    public void setParams(HashMap attrList) {
        this.raName = (String)attrList.get("resource-adapter-name");
        this.name = (String)attrList.get("name");
        this.threadPoolIds = (String)attrList.get("thread-pool-ids");
        this.objectType = (String)attrList.get("object-type");
    }
}

