/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsf.event;

import java.net.URLDecoder;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import jmaki.runtime.IOUtil;
import jmaki.runtime.jsf.event.JMakiEventListener;
import org.json.JSONException;
import org.json.JSONObject;

public class JMakiEvent
extends FacesEvent {
    public static final long serialVersionUID = 938456284988343254L;
    private String message;
    private String topic = null;

    public JMakiEvent(UIComponent component, String message) {
        super(component);
        try {
            this.message = URLDecoder.decode(message, "UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isAppropriateListener(FacesListener listener) {
        Object[] patterns;
        if (listener instanceof JMakiEventListener && (patterns = ((JMakiEventListener)listener).getSubscribe()) != null && patterns.length > 0) {
            String topic = this.getTopic();
            for (int i = 0; i < patterns.length; ++i) {
                Object pattern = patterns[i];
                if (!(pattern instanceof Pattern ? ((Pattern)pattern).matcher(topic).matches() : pattern instanceof String && IOUtil.matchWildcard((String)pattern, topic))) continue;
                return true;
            }
        }
        return false;
    }

    public void processListener(FacesListener listener) {
        ((JMakiEventListener)listener).processJMakiEvent(this);
    }

    private String getTopic() {
        if (this.topic == null) {
            if (this.message != null) {
                try {
                    JSONObject messageObject = new JSONObject(this.message);
                    this.topic = messageObject.getString("topic");
                }
                catch (JSONException je) {
                    this.topic = "";
                }
            } else {
                this.topic = "";
            }
        }
        return this.topic;
    }
}

