/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineConnection;

class PiggyBackedSessionData {
    private int iso_;
    private boolean isoMod_;
    private String schema_;
    private boolean schemaMod_;
    private final EngineConnection conn_;

    public static PiggyBackedSessionData getInstance(PiggyBackedSessionData piggyBackedSessionData, EngineConnection engineConnection, boolean bl) throws SQLException {
        if (engineConnection == null || engineConnection.isClosed() || piggyBackedSessionData != null && piggyBackedSessionData.conn_ != engineConnection) {
            return null;
        }
        if (piggyBackedSessionData == null && bl) {
            return new PiggyBackedSessionData(engineConnection);
        }
        return piggyBackedSessionData;
    }

    private PiggyBackedSessionData(EngineConnection engineConnection) throws SQLException {
        this.conn_ = engineConnection;
        this.iso_ = -1;
    }

    public void refresh() throws SQLException {
        String string;
        this.setUnmodified();
        int n = this.conn_.getTransactionIsolation();
        if (n != this.iso_) {
            this.isoMod_ = true;
            this.iso_ = n;
        }
        if (!(string = this.conn_.getCurrentSchemaName()).equals(this.schema_)) {
            this.schemaMod_ = true;
            this.schema_ = string;
        }
    }

    public void setUnmodified() {
        this.isoMod_ = false;
        this.schemaMod_ = false;
    }

    public boolean isIsoModified() {
        return this.isoMod_;
    }

    public boolean isSchemaModified() {
        return this.schemaMod_;
    }

    public boolean isModified() {
        return this.isoMod_ || this.schemaMod_;
    }

    public int getIso() {
        return this.iso_;
    }

    public String getSchema() {
        return this.schema_;
    }

    public String toString() {
        return "iso:" + this.iso_ + (this.isoMod_ ? "(M)" : "") + " schema:" + this.schema_ + (this.schemaMod_ ? "(M)" : "");
    }
}

