/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.server.logging.Syslog;
import com.sun.enterprise.v3.common.BooleanLatch;
import com.sun.logging.LogDomains;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
@ContractProvided(value=Handler.class)
public class SyslogHandler
extends Handler
implements PostConstruct,
PreDestroy {
    @Inject
    ServerEnvironmentImpl env;
    private Syslog sysLogger;
    private Thread pump = null;
    private BooleanLatch done = new BooleanLatch();
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);

    public void postConstruct() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String systemLogging = TranslatedConfigView.getTranslatedValue((Object)manager.getProperty((cname = this.getClass().getName()) + ".useSystemLogging")).toString();
        if (systemLogging.equals("false")) {
            return;
        }
        try {
            this.sysLogger = new Syslog("localhost");
        }
        catch (UnknownHostException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "unknown host");
            return;
        }
        this.pump = new Thread(){

            public void run() {
                try {
                    while (!SyslogHandler.this.done.isSignalled()) {
                        SyslogHandler.this.log();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.pump.start();
    }

    public void preDestroy() {
        LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin").fine("SysLog Logger handler killed");
    }

    public void log() {
        String slLvl;
        LogRecord record;
        try {
            record = this.pendingRecords.take();
        }
        catch (InterruptedException e) {
            return;
        }
        Level level = record.getLevel();
        long millisec = record.getMillis();
        if (level.equals(Level.SEVERE)) {
            int l = 2;
            slLvl = "CRIT";
        } else if (level.equals(Level.WARNING)) {
            int l = 4;
            slLvl = "WARNING";
        } else if (level.equals(Level.INFO)) {
            int l = 6;
            slLvl = "INFO";
        } else {
            int l = 7;
            slLvl = "DEBUG";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd HH:mm:ss");
        String msg = formatter.format(millisec);
        msg = msg + " [ " + slLvl + " glassfish ] " + record.getMessage();
        this.sysLogger.log(24, 4, msg);
    }

    public void publish(LogRecord record) {
        if (this.pump == null) {
            return;
        }
        try {
            this.pendingRecords.add(record);
        }
        catch (IllegalStateException e) {
            try {
                this.pendingRecords.put(record);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void close() {
    }

    public void flush() {
    }
}

