/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.inbound;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.api.MessageBeanListener;
import org.glassfish.ejb.api.MessageBeanProtocolManager;

public final class MessageEndpointInvocationHandler
implements InvocationHandler {
    private MessageBeanListener listener_;
    private boolean beforeDeliveryCalled = false;
    private boolean throwTransactedExceptions_ = true;
    private MessageBeanProtocolManager messageBeanPM_;
    private static final String MESSAGE_ENDPOINT = "javax.resource.spi.endpoint.MessageEndpoint";
    private static final String THROW_TRANSACTED_EXCEPTIONS_PROP = "resourceadapter.throw.transacted.exceptions";
    private static final Logger logger = LogDomains.getLogger(MessageEndpointInvocationHandler.class, (String)"javax.enterprise.resource.resourceadapter");

    public MessageEndpointInvocationHandler(MessageBeanListener listener, MessageBeanProtocolManager pm) {
        this.listener_ = listener;
        this.messageBeanPM_ = pm;
        this.throwTransactedExceptions_ = ConnectorConstants.THROW_TRANSACTED_EXCEPTIONS;
        if (!this.throwTransactedExceptions_) {
            logger.info("resourceadapter.throw.transacted.exceptions set to false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodClassName = method.getDeclaringClass().getName();
        String methodName = method.getName();
        Object returnValue = null;
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "Invoking method [" + methodName + "] from class [" + methodClassName + "]";
            logger.log(Level.FINEST, msg);
        }
        if (MESSAGE_ENDPOINT.equals(methodClassName)) {
            if ("beforeDelivery".equals(methodName)) {
                Method onMessageMethod = (Method)args[0];
                this.beforeDeliveryCalled = true;
                this.listener_.beforeMessageDelivery(onMessageMethod, false);
                return returnValue;
            }
            if ("afterDelivery".equals(methodName)) {
                this.beforeDeliveryCalled = false;
                this.listener_.afterMessageDelivery();
                return returnValue;
            }
            if ("release".equals(methodName)) {
                this.messageBeanPM_.destroyMessageBeanListener(this.listener_);
                return returnValue;
            }
            logger.log(Level.SEVERE, "endpointfactory.method_not_defined", new Object[]{methodName, MESSAGE_ENDPOINT});
            throw new RuntimeException(methodName);
        }
        if ("java.lang.Object".equals(methodClassName)) {
            return this.invokeJavaObjectMethod(this, method, args);
        }
        if (!this.beforeDeliveryCalled) {
            JavaEETransactionManager txManager = ConnectorRuntime.getRuntime().getTransactionManager();
            boolean txImported = txManager.getTransaction() != null;
            this.listener_.beforeMessageDelivery(method, txImported);
        }
        try {
            returnValue = this.listener_.deliverMessage(args);
            return returnValue;
        }
        catch (Throwable ex) {
            if (!this.messageBeanPM_.isDeliveryTransacted(method)) throw ex;
            if (this.throwTransactedExceptions_) {
                throw ex;
            }
            logger.log(Level.INFO, "Resource adapter eating  transacted exception", ex);
            return returnValue;
        }
        finally {
            if (!this.beforeDeliveryCalled) {
                this.listener_.afterMessageDelivery();
            }
            this.beforeDeliveryCalled = false;
        }
    }

    private Object invokeJavaObjectMethod(InvocationHandler handler, Method method, Object[] args) throws RuntimeException {
        Object returnValue = null;
        switch (method.getName().charAt(0)) {
            case 'e': {
                Object other = Proxy.isProxyClass(args[0].getClass()) ? Proxy.getInvocationHandler(args[0]) : args[0];
                returnValue = new Boolean(handler.equals(other));
                break;
            }
            case 'h': {
                returnValue = new Integer(handler.hashCode());
                break;
            }
            case 't': {
                returnValue = handler.toString();
                break;
            }
            default: {
                throw new RuntimeException(method.getName());
            }
        }
        return returnValue;
    }
}

