/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public class JaxrConnectionEventListener {
    private Vector listeners;
    private ManagedConnection mcon;
    Logger log = Logger.getLogger("com.sun.connector.jaxr");

    public JaxrConnectionEventListener(ManagedConnection managedConnection) {
        this.listeners = new Vector();
        this.log.fine("JAXRConnectionEventListener constructor - ManagedConnection as parameter");
        this.mcon = managedConnection;
    }

    public void sendEvent(int n, Exception exception, Object object) {
        Vector vector = (Vector)this.listeners.clone();
        ConnectionEvent connectionEvent = null;
        this.log.fine("JAXRConnectionEventListener sendEvent creating connection Event");
        connectionEvent = exception == null ? new ConnectionEvent(this.mcon, n) : new ConnectionEvent(this.mcon, n, exception);
        if (object != null) {
            this.log.fine("JAXRConnectionEventListener sendEvent setting connection handle on connection Event");
            connectionEvent.setConnectionHandle(object);
        }
        int n2 = vector.size();
        block7: for (int i = 0; i < n2; ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)vector.elementAt(i);
            this.log.fine("JAXRConnectionEventListener sendEvent processing eventType connection Event");
            switch (n) {
                case 1: {
                    connectionEventListener.connectionClosed(connectionEvent);
                    this.log.fine("JAXRConnectionEventListener sendEvent processing Closed eventType --calling listener.closed");
                    continue block7;
                }
                case 2: {
                    connectionEventListener.localTransactionStarted(connectionEvent);
                    continue block7;
                }
                case 3: {
                    connectionEventListener.localTransactionCommitted(connectionEvent);
                    continue block7;
                }
                case 4: {
                    connectionEventListener.localTransactionRolledback(connectionEvent);
                    continue block7;
                }
                case 5: {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Illegal_eventType:_") + n);
                }
            }
        }
    }

    public void addConnectorListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectorListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.log.fine("JAXRConnectionEventListener connectionClosed - doing nothing");
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        this.sendEvent(5, null, null);
    }
}

