/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.FieldVisitor;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.InstrumentUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ClassRenamer
extends ClassAdapter {
    private String oldName;
    private String newName;
    private String oldNameDesc;
    private String newNameDesc;

    public ClassRenamer(String newName, ClassVisitor visitor) {
        super(visitor);
        this.newName = newName = newName.replace('.', '/');
        this.newNameDesc = "L" + newName + ";";
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.oldName = name;
        this.oldNameDesc = "L" + this.oldName + ";";
        if (signature != null) {
            signature = signature.replace(this.oldNameDesc, this.newNameDesc);
        }
        super.visit(version, access, this.newName, signature, superName, interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        desc = desc.replace(this.oldNameDesc, this.newNameDesc);
        if (signature != null) {
            signature = signature.replace(this.oldNameDesc, this.newNameDesc);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature != null) {
            signature = signature.replace(this.oldNameDesc, this.newNameDesc);
        }
        desc = desc.replace(this.oldNameDesc, this.newNameDesc);
        MethodVisitor adaptee = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodAdapter(adaptee){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (owner.equals(ClassRenamer.this.oldName)) {
                    owner = ClassRenamer.this.newName;
                }
                desc = desc.replace(ClassRenamer.this.oldNameDesc, ClassRenamer.this.newNameDesc);
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (owner.equals(ClassRenamer.this.oldName)) {
                    owner = ClassRenamer.this.newName;
                }
                desc = desc.replace(ClassRenamer.this.oldNameDesc, ClassRenamer.this.newNameDesc);
                super.visitMethodInsn(opcode, owner, name, desc);
            }

            @Override
            public void visitLdcInsn(Object cst) {
                String name;
                if (cst instanceof Type && (name = ((Type)cst).getInternalName()).equals(ClassRenamer.this.oldName)) {
                    cst = Type.getType(ClassRenamer.this.newNameDesc);
                }
                super.visitLdcInsn(cst);
            }

            @Override
            public void visitTypeInsn(int opcode, String desc) {
                if (desc.equals(ClassRenamer.this.oldName)) {
                    desc = ClassRenamer.this.newName;
                }
                if (desc.equals(ClassRenamer.this.oldNameDesc)) {
                    desc = ClassRenamer.this.newNameDesc;
                }
                desc = desc.replace(ClassRenamer.this.oldNameDesc, ClassRenamer.this.newNameDesc);
                super.visitTypeInsn(opcode, desc);
            }

            @Override
            public void visitMultiANewArrayInsn(String desc, int dims) {
                desc = desc.replace(ClassRenamer.this.oldNameDesc, ClassRenamer.this.newNameDesc);
                super.visitMultiANewArrayInsn(desc, dims);
            }

            @Override
            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                desc = desc.replace(ClassRenamer.this.oldNameDesc, ClassRenamer.this.newNameDesc);
                if (signature != null) {
                    signature = signature.replace(ClassRenamer.this.oldNameDesc, ClassRenamer.this.newNameDesc);
                }
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java com.sun.btrace.runtime.ClassRenamer <class> <new-class-name>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        args[1] = args[1].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[1] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassRenamer(args[1], writer));
        fos.write(writer.toByteArray());
    }
}

