/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.BitSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.framework.BundleContext;

public class FilePersistenceManager
implements PersistenceManager {
    public static final String DEFAULT_CONFIG_DIR = "config";
    private static final String FILE_EXT = ".config";
    private static final String TMP_EXT = ".tmp";
    private static final BitSet VALID_PATH_CHARS;
    private final AccessControlContext acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
    private final File location;

    static String encodePid(String pid) {
        int first;
        pid = pid.replace('.', File.separatorChar);
        if (File.separatorChar != '/') {
            pid = pid.replace('/', File.separatorChar);
        }
        for (first = 0; first < pid.length() && VALID_PATH_CHARS.get(pid.charAt(first)); ++first) {
        }
        if (first < pid.length()) {
            StringBuffer buf = new StringBuffer(pid.substring(0, first));
            for (int i = first; i < pid.length(); ++i) {
                char c = pid.charAt(i);
                if (VALID_PATH_CHARS.get(c)) {
                    buf.append(c);
                    continue;
                }
                String val = "000" + Integer.toHexString(c);
                buf.append('%');
                buf.append(val.substring(val.length() - 4));
            }
            pid = buf.toString();
        }
        return pid;
    }

    public FilePersistenceManager(String location) {
        this(null, location);
    }

    public FilePersistenceManager(BundleContext bundleContext, String location) {
        File locationFile;
        if (location == null && bundleContext != null && (locationFile = bundleContext.getDataFile(DEFAULT_CONFIG_DIR)) != null) {
            location = locationFile.getAbsolutePath();
        }
        if (location == null) {
            location = System.getProperty("user.dir") + "/config";
        }
        if (!(locationFile = new File(location)).isAbsolute()) {
            File bundleLocationFile;
            if (bundleContext != null && (bundleLocationFile = bundleContext.getDataFile(locationFile.getPath())) != null) {
                locationFile = bundleLocationFile;
            }
            locationFile = locationFile.getAbsoluteFile();
        }
        if (!locationFile.isDirectory()) {
            if (locationFile.exists()) {
                throw new IllegalArgumentException(location + " is not a directory");
            }
            if (!locationFile.mkdirs()) {
                throw new IllegalArgumentException("Cannot create directory " + location);
            }
        }
        this.location = locationFile;
    }

    public File getLocation() {
        return this.location;
    }

    public Enumeration getDictionaries() {
        return new DictionaryEnumeration();
    }

    public void delete(String pid) {
        if (System.getSecurityManager() != null) {
            this._privilegedDelete(pid);
        } else {
            this._delete(pid);
        }
    }

    private void _privilegedDelete(final String pid) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FilePersistenceManager.this._delete(pid);
                return null;
            }
        }, this.acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _delete(String pid) {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            this.getFile(pid).delete();
        }
    }

    public boolean exists(String pid) {
        if (System.getSecurityManager() != null) {
            return this._privilegedExists(pid);
        }
        return this._exists(pid);
    }

    private boolean _privilegedExists(final String pid) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FilePersistenceManager.this._exists(pid);
            }
        });
        return (Boolean)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _exists(String pid) {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            return this.getFile(pid).isFile();
        }
    }

    public Dictionary load(String pid) throws IOException {
        File cfgFile = this.getFile(pid);
        if (System.getSecurityManager() != null) {
            return this._privilegedLoad(cfgFile);
        }
        return this._load(cfgFile);
    }

    private Dictionary _privilegedLoad(final File cfgFile) throws IOException {
        try {
            Object result = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return FilePersistenceManager.this._load(cfgFile);
                }
            });
            return (Dictionary)result;
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary _load(File cfgFile) throws IOException {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            Dictionary dictionary;
            block11: {
                FileInputStream ins = null;
                try {
                    ins = new FileInputStream(cfgFile);
                    dictionary = ConfigurationHandler.read(ins);
                    if (ins == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ins != null) {
                        try {
                            ((InputStream)ins).close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return dictionary;
        }
    }

    public void store(String pid, Dictionary props) throws IOException {
        if (System.getSecurityManager() != null) {
            this._privilegedStore(pid, props);
        } else {
            this._store(pid, props);
        }
    }

    private void _privilegedStore(final String pid, final Dictionary props) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    FilePersistenceManager.this._store(pid, props);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _store(String pid, Dictionary props) throws IOException {
        OutputStream out = null;
        File tmpFile = null;
        try {
            File cfgFile = this.getFile(pid);
            File cfgDir = cfgFile.getParentFile();
            cfgDir.mkdirs();
            tmpFile = File.createTempFile(cfgFile.getName(), TMP_EXT, cfgDir);
            out = new FileOutputStream(tmpFile);
            ConfigurationHandler.write(out, props);
            out.close();
            FilePersistenceManager filePersistenceManager = this;
            synchronized (filePersistenceManager) {
                if (cfgFile.exists()) {
                    cfgFile.delete();
                }
                if (!tmpFile.renameTo(cfgFile)) {
                    throw new IOException("Failed to rename configuration file from '" + tmpFile + "' to '" + cfgFile);
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }

    File getFile(String pid) {
        return new File(this.location, FilePersistenceManager.encodePid(pid) + FILE_EXT);
    }

    static {
        int i;
        VALID_PATH_CHARS = new BitSet();
        for (i = 97; i <= 122; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        VALID_PATH_CHARS.set(File.separatorChar);
        VALID_PATH_CHARS.set(32);
        VALID_PATH_CHARS.set(45);
        VALID_PATH_CHARS.set(95);
    }

    class DictionaryEnumeration
    implements Enumeration {
        private Stack dirStack = new Stack();
        private File[] fileList = null;
        private int idx = 0;
        private Dictionary next;

        DictionaryEnumeration() {
            this.dirStack.push(FilePersistenceManager.this.getLocation());
            this.next = this.seek();
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Dictionary toReturn = this.next;
            this.next = this.seek();
            return toReturn;
        }

        private Dictionary seek() {
            if (System.getSecurityManager() != null) {
                return this._privilegedSeek();
            }
            return this._seek();
        }

        protected Dictionary _privilegedSeek() {
            Object result = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return DictionaryEnumeration.this._seek();
                }
            });
            return (Dictionary)result;
        }

        protected Dictionary _seek() {
            while (this.fileList != null && this.idx < this.fileList.length || !this.dirStack.isEmpty()) {
                File cfgFile;
                if (this.fileList == null || this.idx >= this.fileList.length) {
                    File dir = (File)this.dirStack.pop();
                    this.fileList = dir.listFiles();
                    this.idx = 0;
                    continue;
                }
                if ((cfgFile = this.fileList[this.idx++]).isFile() && !cfgFile.getName().endsWith(FilePersistenceManager.TMP_EXT)) {
                    try {
                        Dictionary dict = FilePersistenceManager.this._load(cfgFile);
                        if (dict.get("service.pid") != null && !cfgFile.equals(FilePersistenceManager.this.getFile((String)dict.get("service.pid")))) continue;
                        return dict;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (!cfgFile.isDirectory()) continue;
                this.dirStack.push(cfgFile);
            }
            return null;
        }
    }
}

