/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.mail.MailMessage;

public class Kvetcher
extends Task
implements BuildListener {
    private Explanation explanation = null;
    private String target;
    private String from = null;
    private String subject = "Errors in sources";
    private String mailhost = "localhost";
    private List culprits = new ArrayList(20);
    private List messages = new ArrayList(1000);

    public Explanation createExplanation() {
        Kvetcher kvetcher = this;
        if (kvetcher == null) {
            throw null;
        }
        this.explanation = kvetcher.new Explanation();
        return this.explanation;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public void setFrom(String f) {
        this.from = f;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setMailhost(String mh) {
        this.mailhost = mh;
    }

    public Culprit createCulprit() {
        Kvetcher kvetcher = this;
        if (kvetcher == null) {
            throw null;
        }
        Culprit c = kvetcher.new Culprit();
        this.culprits.add(c);
        return c;
    }

    public void execute() throws BuildException {
        if (this.target == null) {
            throw new BuildException("set the target");
        }
        if (this.culprits.isEmpty()) {
            throw new BuildException("add some culprits");
        }
        Iterator it = this.culprits.iterator();
        while (it.hasNext()) {
            if (((Culprit)it.next()).isValid()) continue;
            throw new BuildException("invalid <culprit>");
        }
        ((ProjectComponent)this).project.addBuildListener((BuildListener)this);
        boolean success = false;
        try {
            ((ProjectComponent)this).project.executeTarget(this.target);
            success = true;
        }
        finally {
            Object var4_3 = null;
            ((ProjectComponent)this).project.removeBuildListener((BuildListener)this);
        }
        if (success) {
            this.sendMail();
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
        int pri = buildEvent.getPriority();
        if (pri == 1 || pri == 0) {
            this.messages.add(buildEvent.getMessage());
        }
    }

    private void sendMail() throws BuildException {
        Iterator it = this.culprits.iterator();
        while (it.hasNext()) {
            try {
                Culprit c = (Culprit)it.next();
                MailMessage mail = null;
                boolean send = false;
                PrintStream ps = null;
                Iterator it2 = this.messages.iterator();
                block3: while (it2.hasNext()) {
                    String msg = (String)it2.next();
                    Iterator it3 = c.regexp.iterator();
                    while (it3.hasNext()) {
                        Regexp r = (Regexp)it3.next();
                        if (!r.pattern.match(msg)) continue;
                        if (mail == null) {
                            this.log("Sending mail to " + ((Address)c.to.get((int)0)).name);
                            mail = new MailMessage(this.mailhost);
                            if (this.from == null) {
                                this.from = "kvetcher@" + this.mailhost;
                            }
                            mail.from(this.from);
                            Iterator it4 = c.to.iterator();
                            while (it4.hasNext()) {
                                mail.to(((Address)it4.next()).name);
                            }
                            it4 = c.cc.iterator();
                            while (it4.hasNext()) {
                                mail.cc(((Address)it4.next()).name);
                            }
                            mail.setSubject(this.subject);
                            ps = mail.getPrintStream();
                            if (this.explanation != null) {
                                ps.println(this.explanation.text.toString());
                            }
                            ps.println();
                        }
                        ps.println(r.group == -1 ? msg : r.pattern.getParen(r.group));
                        continue block3;
                    }
                }
                if (mail == null) continue;
                mail.sendAndClose();
            }
            catch (IOException ioe) {
                throw new BuildException("While sending mail", (Throwable)ioe, this.location);
            }
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public final class Explanation {
        StringBuffer text = new StringBuffer();

        public void addText(String s) {
            this.text.append(s);
        }
    }

    public final class Culprit {
        List to = new ArrayList(1);
        List cc = new ArrayList(1);
        List regexp = new ArrayList(5);

        public Address createTo() {
            Kvetcher kvetcher = Kvetcher.this;
            if (kvetcher == null) {
                throw null;
            }
            Address a = kvetcher.new Address();
            this.to.add(a);
            return a;
        }

        public Address createCC() {
            Kvetcher kvetcher = Kvetcher.this;
            if (kvetcher == null) {
                throw null;
            }
            Address a = kvetcher.new Address();
            this.cc.add(a);
            return a;
        }

        public Regexp createRegexp() {
            Kvetcher kvetcher = Kvetcher.this;
            if (kvetcher == null) {
                throw null;
            }
            Regexp r = kvetcher.new Regexp();
            this.regexp.add(r);
            return r;
        }

        boolean isValid() {
            if (this.to.isEmpty() && this.cc.isEmpty() || this.regexp.isEmpty()) {
                return false;
            }
            Iterator it = this.to.iterator();
            while (it.hasNext()) {
                if (((Address)it.next()).isValid()) continue;
                return false;
            }
            it = this.cc.iterator();
            while (it.hasNext()) {
                if (((Address)it.next()).isValid()) continue;
                return false;
            }
            it = this.regexp.iterator();
            while (it.hasNext()) {
                if (((Regexp)it.next()).isValid()) continue;
                return false;
            }
            return true;
        }
    }

    public final class Address {
        String name;

        public void setName(String n) {
            this.name = n;
        }

        boolean isValid() {
            return this.name != null;
        }
    }

    public final class Regexp {
        RE pattern;
        int group = -1;

        public void setPattern(String p) throws BuildException {
            try {
                this.pattern = new RE(p);
            }
            catch (RESyntaxException rese) {
                throw new BuildException((Throwable)rese, Kvetcher.this.location);
            }
        }

        public void setGroup(int g) {
            this.group = g;
        }

        boolean isValid() {
            return this.pattern != null;
        }
    }
}

