/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/InvokeResult.java,v 1.3 2005/12/25 03:45:48 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:48 $
 */
 

package com.sun.cli.jmx.support;

import java.io.Serializable;


import javax.management.ObjectName;


public final class InvokeResult implements Serializable
{
	public final ObjectName	mObjectName;
	public Object			mResult;
	public Throwable		mThrowable;
	
	public static final class ResultType
	{
		final int	mResultType;
			private
		ResultType( int value )
		{
			mResultType	= value;
		}
	}
	
	public final static ResultType	SUCCESS		= new ResultType( 0 );
	public final static ResultType	FAILURE		= new ResultType( 1 );
	public final static ResultType	NOT_FOUND	= new ResultType( 2 );
	
		public
	InvokeResult( ObjectName name, Object result, Throwable t )
	{
		mObjectName		= name;
		mResult			= result;
		mThrowable		= t;
	}
	
		public ResultType
	getResultType()
	{
		ResultType	result	= NOT_FOUND;
		
		if ( mThrowable == null )
		{
			result	= SUCCESS;
		}
		else
		{
			if ( mThrowable instanceof java.lang.NoSuchMethodException )
			{
				result	= NOT_FOUND;
			}
			else
			{
				result	= FAILURE;
			}
		}
		
		return( result );
	}
}