/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import java.io.IOException;

/**
   This class gets called when create-file-user command is invoked.
   This class will overwrite validOptions in GenericCommand to validate
   the userpassword option.  If the userpassword and passwordfile options
   are not entered in the command line and interactive is true, then
   CLI will prompt the user for the password.
 */
public class FileUserCommand extends S1ASCommand
{
    private static final String USER_PASSWORD  = "userpassword";
    private static final String FILE_USER_NAME = "fileuser";
    
    protected String getPasswordOptionName() {
        return USER_PASSWORD;
    }
    
    
    protected String getPasswordPrompt()
    {
        return "FileUserPasswordPrompt";
    }
    

    protected String getPasswordConfirmationPrompt()
    {
        return "FileUserPasswordConfirmationPrompt";
    }
    
    
    protected boolean confirmPassword() {
        return true;
    }

        /*
    protected String getPasswordOption() throws CommandValidationException
    {
        String password;
        if (getOption(getPasswordOptionName()) != null)
            password = getOption(getPasswordOptionName());
        else //prompt for fileuserPassword
        {
            password = getInteractiveOptionWithConfirmation(
                            getPasswordOptionName(), 
                            getLocalizedString(getPasswordPrompt()), 
                            getLocalizedString(getPasswordConfirmationPrompt()), 
                            false);
        }   
        return password;
    }
        */
    
    protected String getUserOptionName() {
        return FILE_USER_NAME;
    }
    
    
    protected String getUserPrompt()
    {
        return "FileUserPrompt";
    }
    
    
    /**
     *  this methods returns the user/alias password. 
     *  @return user/alias password
     *  @throws CommandValidationException if could not get userpassword or
     *  aliaspassword option 
     */
    protected String getPasswordOption()     
        throws CommandValidationException, CommandException
    {
        //getPassword(optionName, allowedOnCommandLine, readPrefsFile, readPasswordOptionFromPrefs, readMasterPasswordFile, mgr, config,
        //promptUser, confirm, validate)
        return getPassword(getPasswordOptionName(), getPasswordPrompt(), 
                            getPasswordConfirmationPrompt(),
                            true, false, false, false, null, null,
                            true, confirmPassword(), false, true);
    }

    
    private String getUserName() throws CommandValidationException
    {
        String userName;
        if ((getOperands() != null) && (getOperands().size() != 0))
            userName = (String) getOperands().get(0);
        else //prompt for fileuser
        {
            try {
                InputsAndOutputs.getInstance().getUserOutput().print(
                                    getLocalizedString(this.getUserPrompt()));
                userName = InputsAndOutputs.getInstance().getUserInput().getLine();
            }
            catch (IOException ioe)
            {
                throw new CommandValidationException(
                            getLocalizedString("CannotReadOption", 
                                        new Object[]{getUserOptionName()}));
            }
        }   
        
        return userName;
    }
    
    
    /**
       Validate the userpassword option.
     */    
    public boolean validateOptions() throws CommandValidationException
    {
    	return super.validateOptions();
    }
    
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                              getUser(), getPassword());
        final String objectName = getObjectName();
        final Object[] params = getParamsInfo();
        final String operationName = getOperationName();
        final String[] types = getTypesInfo();

        //get fileuser and set it in the params
        params[0] = getUserName();
        //get fileuser password and set it in the params
        params[1] = getPasswordOption();
        try
        { 
	    //if (System.getProperty("Debug") != null) printDebug(mbsc, objectName);
            Object returnValue = mbsc.invoke(new ObjectName(objectName), 
					     operationName, params, types);
            handleReturnValue(returnValue);
	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }        
    }
}
