/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.util.HashMap;
import java.util.Iterator;
import java.io.Serializable;

/**
 * The class holds the list of ValidCommand's
 *      @version  $Revision: 1.3 $
 */
public class ValidCommandsList implements Serializable
{

    private HashMap validCommands = null;
    
    /** Creates new ValidCommandsList */
    public ValidCommandsList() 
    {
        validCommands = new HashMap();
    }

    
    /**
     * Returns the ValidCommand that macthes the parameter command name
     * @param commandName The name of the command that should be checked in the list
     * @return ValidCommand The ValidCommand object
     */
    public ValidCommand getValidCommand(String commandName) 
    {
        return (ValidCommand) validCommands.get(commandName);
    }
 
    
    /**
     * Return the list of ValidCommand's
     */
    public Iterator getCommands()
    {
        return validCommands.values().iterator();
    }
    
    
    /**
     * Return the number of commands in the list
    **/
    public int size()
    {
        return validCommands.size();
    }
 
    
     /** Adds the ValidCommand to ValidCommandsList
     * @param command The Valid command to be added to the list
     */
    public void addCommand(ValidCommand command)
    {
        validCommands.put(command.getName(), command);
    }

    
    /** Removes all commands from this list
     */
    public void removeAllCommands()
    {
        validCommands.clear();
    }
}
