/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/base/AllDottedNames.java,v 1.3 2005/12/25 03:48:54 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:48:54 $
 */


package com.sun.appserv.management.base;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;

/**
	Marker interface for exposing all <i>asadmin</i> CLI dotted names 
	as JMX <i>Attributes</i>.
	<p>
	The set of dotted names is variable and dynamic.  For that reason, no 
	specific dotted names are defined in this interface. A client wishing
	to determine which dotted names are available can determine them by
	obtaining MBeanInfo or by calling {@link Util#getExtra} and then calling
	{@link Extra#getAttributeNames}.  
	<p>
	Attributes can be accessed through the usual mechanisms such as
	{@link StdAttributesAccess} and {@link DottedNames}.

	@see DottedNames
	@see com.sun.appserv.management.config.ConfigDottedNames
	@see com.sun.appserv.management.monitor.MonitoringDottedNames
 */
public interface AllDottedNames extends AMX
{
}



