/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;

import java.io.IOException;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;

/**
	Standard API for access to JMX MBean Attributes.  The exceptions from these
	calls are the same as those that would be thrown if the same routines
	were invoked through an MBeanServerConnection.
 */
public interface StdAttributesAccess
{
	public Object		getAttribute( String name )
							throws InstanceNotFoundException, ReflectionException,
							MBeanException, AttributeNotFoundException, IOException;
                           
	public AttributeList	getAttributes( String[] names )
								throws InstanceNotFoundException, ReflectionException,
								IOException;
	
	public void				setAttribute( Attribute attr )
								throws InstanceNotFoundException, ReflectionException,
                         		MBeanException, AttributeNotFoundException, InvalidAttributeValueException,
                         		IOException;
                         		
	public AttributeList	setAttributes( AttributeList attrs )
								throws InstanceNotFoundException, ReflectionException,
								IOException;
}
