/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.prefs;

/**
 * An immutable class that represents an arbitrary LoginInfo for Appserver Administration Client. A LoginInfo
 * is specific to an admin host and admin port. Thus, with this scheme, there can be
 * at the most one LoginInfo for an operating system user of Appserver, for a given admin host
 * and admin port.
 * @since Appserver 9.0
 */
public final class LoginInfo implements Comparable<LoginInfo> {
    private String host;
    private int    port;
    private String user;
    private String password;
    
    /**
     * Creates an Immutable instance of a LoginInfo from given 4-tuple. 
     * The host, user and password may not be null.
     * The port may not be a negative integer.
     * @param host String representing host
     * @param port integer representing port
     * @param user String representing user
     * @param password String representing password
     * @throws IllegalArgumentException if parameter contract is violated
     */
    public LoginInfo(final String host, final int port, final String user, final String password) {
        if (host == null || port < 0 || user == null || password == null)
            throw new IllegalArgumentException("null value"); // TODO
        init(host, port, user, password);
    }
    public String getHost() {
        return ( host );
    }
    public int getPort() {
        return ( port );
    }
    public String getUser() {
        return ( user );
    }
    public String getPassword() {
        return ( password );
    }
    public boolean equals(final Object other) {
        boolean same = false;
        if (other instanceof LoginInfo) {
            final LoginInfo that = (LoginInfo) other;
            same = this.host.equals(that.host) &&
                   this.port == that.port      &&
                   this.user.equals(that.user) &&
                   this.password.equals(that.password);
        }
        return ( same );
    }
    public int hashCode() {
        return ( (int) 31 * host.hashCode() + 23 * port + 53 * user.hashCode() + 13 * password.hashCode() );
    }
    
    private void init(final String host, final int port, final String user, final String password) {
        this.host     = host;
        this.port     = port;
        this.user     = user;
        this.password = password;
    }
    
    public String toString() {
        return ( host + port + user + password );
    }

    public int compareTo(final LoginInfo that) {
        final String thisKey = this.user + this.host + this.port;
        final String thatKey = that.user + that.host + that.port;        
        return ( thisKey.compareTo(thatKey) );
    }
}