/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/ProviderConfig.java,v 1.4.2.1 2006/09/21 22:49:13 ne110415 Exp $
 * $Revision: 1.4.2.1 $
 * $Date: 2006/09/21 22:49:13 $
 */


package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
	 Configuration for the &lt;provider-config&gt; element.
*/

public interface ProviderConfig
	extends NamedConfigElement, PropertiesAccess, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.PROVIDER_CONFIG;
	
	/** Key for use with {@link #createRequestPolicyConfig} and {@link #createResponsePolicyConfig}*/
	public static final String	AUTH_SOURCE_KEY		=	"AuthSource";
	
	/** Key for use with {@link #createRequestPolicyConfig} and {@link #createResponsePolicyConfig}*/
	public static final String	AUTH_RECIPIENT_KEY	=	"AuthRecipient";

    /**  */
    public static final String PROVIDER_TYPE_CLIENT = "client";
    
    /**  */
    public static final String PROVIDER_TYPE_SERVER = "server";
    
	public String	getClassName();
	public void	setClassName( final String value );

	public String	getProviderId();

    /** Returns {@link #PROVIDER_TYPE_CLIENT} or {@link #PROVIDER_TYPE_SERVER} */
	public String	getProviderType();
    
    /** Use {@link #PROVIDER_TYPE_CLIENT} or {@link #PROVIDER_TYPE_SERVER} */
	public void	setProviderType( final String value );

// -------------------- Operations --------------------
	/**
		Creates new request-policy-config element.

		@param optional Map of optional attributes whose keys are defined here.
		(eg:- AUTH_RECIPIENT_KEY)
		@return A proxy to the RequestPolicyConfig MBean.
	 */
	public RequestPolicyConfig	createRequestPolicyConfig( Map<String,String> optional );

	/**
		Removes request-policy-config element.
	 */
	public void					removeRequestPolicyConfig();

	/**
		Get the RequestPolicyConfig MBean.
	 */
	RequestPolicyConfig	getRequestPolicyConfig();

	/**
		Creates new response-policy-config element.

		@param optional Map of optional attributes whose keys are defined here.
		(eg:- AUTH_RECIPIENT_KEY)
		@return A proxy to the ResponsePolicyConfig MBean.
	 */
	public ResponsePolicyConfig		createResponsePolicyConfig( Map<String,String> optional );

	/**
		Removes response-policy-config element.
	 */
	public void						removeResponsePolicyConfig();

	/**
		Get the ResponsePolicyConfig MBean.
	 */
	ResponsePolicyConfig			getResponsePolicyConfig();



}
