/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/SSLConfigKeys.java,v 1.4 2006/02/01 00:48:38 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/02/01 00:48:38 $
 */


package com.sun.appserv.management.config;


/**
	Keys used by when creating a new {@link SSLConfig}.
 */
public final class SSLConfigKeys
{
	private	SSLConfigKeys()	{}
	
	/**
		Value of class java.lang.Boolean
	 */
	public static final String	CLIENT_AUTH_ENABLED_KEY	= "ClientAuthEnabled";
	
	/**
		This key has a value which is a String containing cipher suite names.
		It must be in comma-separated list.  A "+" preceeding a cipher means
		to enable it and a "-" means to not enable it. Candidates include:
	 */
	public static final String	SSL_2_CIPHERS_KEY		= "SSL2Ciphers";
	/**
		This key has a value which is a String containing cipher suite names.
		It must be in comma-separated list.  A "+" preceeding a cipher means
		to enable it and a "-" means to not enable it. Candidates include:
	 */
	public static final String	SSL_3_TLS_CIPHERS_KEY	= "SSL3TLSCiphers";
	
	/**
		Value of class java.lang.Boolean
	 */
	public static final String	SSL_3_ENABLED_KEY		= "SSL3Enabled";
	
	/**
		Value of class java.lang.Boolean
	 */
	public static final String	SSL_2_ENABLED_KEY		= "SSL2Enabled";
	
	/**
		Value of class java.lang.Boolean
	 */
	public static final String	TLS_ENABLED_KEY			= "TLSEnabled";
	
	/**
		Value of class java.lang.Boolean
	 */
	public static final String	TLS_ROLLBACK_ENABLED_KEY= "TLSRollbackEnabled";
	
	/**
		This key has a value which is a String containing cipher suite names.
		It must be in comma-separated list.  A "+" preceeding a cipher means
		to enable it and a "-" means to not enable it. Candidates include:
		<ul>
			<li>rsa_rc4_128_md5</li>
			<li>rsa3des_sha</li>
			<li>rsa_des_sha</li>
			<li>rsa_rc4_40_md5</li>
			<li>rsa_rc2_40_md5</li>
			<li>rsa_null_md5</li>
			<li>rsa_des_56_sha</li>
			<li>rsa_rc4_56_sha</li>
		</ul>
	 */
	public final static String	SSL3_TLS_CIPHERS_KEY		= "ssl3-tls-ciphers";
}

