/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/VirtualServerConfig.java,v 1.5 2006/03/09 20:30:25 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:25 $
 */

package com.sun.appserv.management.config;

import java.util.Map;


import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;


/**
	 Configuration for the &lt;virtual-server&gt; element.
*/

public interface VirtualServerConfig
	extends NamedConfigElement, PropertiesAccess, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.VIRTUAL_SERVER_CONFIG;


	public String	getDefaultWebModule();
	public void	setDefaultWebModule( String value );

	public String	getHosts();
	public void	setHosts( String value );

	public String	getHTTPListeners();
	public void	setHTTPListeners( String value );

    //** default: "${com.sun.aas.instanceRoot}/logs/server.log" */
	public String	getLogFile();
	public void	setLogFile( String value );

	public String	getState();
	public void	setState( String value );
	
	public String	getDocRoot();
	public void	setDocRoot( String value );

	/**
		Removes http-access-log element.
	 */
	void removeHTTPAccessLogConfig();

	/**
		Get the HTTPAccessLogConfig MBean.
	 */
	public HTTPAccessLogConfig	getHTTPAccessLogConfig();

	/**
		Creates new http-access-log element.
	 
		@param	ipOnly
		@param	logDirectory
		@param	reserved
		@return A proxy to the HTTPAccessLogConfig MBean.
	 */
	public HTTPAccessLogConfig createHTTPAccessLogConfig(
		final boolean	ipOnly,
		final String	logDirectory,
		final Map<String,String>		reserved );
}
