/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.ext.wsmgmt;

import java.util.Map;
import java.io.Serializable;

import com.sun.appserv.management.ext.wsmgmt.MessageTrace;


/**
	Routines to convert to/from Map and WebService types.

	{link com.sun.appserv.management.ext.wsmgmt.WebServiceMgr}
 */

public final class WebServiceSupport
{
	/**
		Create a MessageTrace represented by a Map.
		
		@param m a Map representing a MessageTrace.
		@return an implementation of MessageTrace
	 */
		public static MessageTrace
	mapToMessageTrace( final Map<String,Serializable> m )
	{
		return( new MessageTraceImpl( m, MessageTrace.CLASS_NAME ) );
	}
	
    /**
		Create a WebServiceEndpointInfo represented by a Map.
		
		@param m a Map representing a WebServiceEndpointInfo.
		@return an implementation of WebServiceEndpointInfo
	 */
		public static WebServiceEndpointInfo
	mapToWebServiceEndpointInfo( final Map<String,Serializable> m )
	{
		return( new WebServiceEndpointInfoImpl( m, WebServiceEndpointInfo.CLASS_NAME ) );
	}

	
}



