/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.helper;

import java.util.Set;
import java.util.HashSet;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.BulkAccess;

/**
	Base class for Helpers, useable alone as well.
 */
public class Helper
{
	protected final DomainRoot	mDomainRoot;
	protected final QueryMgr		mQueryMgr;
	protected final BulkAccess	mBulkAccess;
	
		public
	Helper( final AMX	proxy )
	{
		mDomainRoot	= proxy.getDomainRoot();
		mQueryMgr		= mDomainRoot.getQueryMgr();
		mBulkAccess	= mDomainRoot.getBulkAccess();
	}
	
		public DomainRoot
	getDomainRoot()
	{
		return( mDomainRoot );
	}
	
		protected <T extends AMX> Set<T>
	propsQuery( final String	props )
	{
		final Set<T>		results	= mQueryMgr.queryPropsSet( props );
		return( results );
	}
	
		protected  <T extends AMX> Set<T>
	propsQuery(
		final String	props1,
		final String	props2 )
	{
		final String	props	= Util.concatenateProps( props1, props2 );
		
		return( propsQuery( props ) );
	}
	
	/**
		Filter ObjectNames based on the value of a particular Attribute.  The value
		may be null or anything else.  This is essentially a crude form of using
		the QueryMgr. A value which is a Class object succeeds if the result is
		an object whose class is assignable to the specfied class. Typically this
		is used to detect a thrown Exception.
		<p>
		For example, to select all MBeans which have a [bB]oolean Attribute named "Enabled",
		which is set to true, call:
		<pre>filterByAttributeValue( objectNameSet, "Enabled", Boolean.TRUE)</pre>
		<p>
		The query for the Attribute value is performed as a bulk operation; thus this
		routine may be used with confidence that it is fast.
		
		
		@param objectNameSet	Set of ObjectName
		@param attributeName	
		@param valueToMatch	an Object whose value must be null, or equals() to the result
		@return Set of ObjectName which have Enabled flag matching
	 */
		public Set<ObjectName>
	filterByAttributeValue(
		final Set<ObjectName>	objectNameSet,
		final String	        attributeName,
		final Object	        valueToMatch )
	{
		final ObjectName[]	objectNames	= new ObjectName[ objectNameSet.size() ];
		objectNameSet.toArray( objectNames );
		
		final Object[]	values	= mBulkAccess.bulkGetAttribute( objectNames, attributeName );
		
		final Set<ObjectName>	filtered	= new HashSet<ObjectName>();
		for( int i = 0; i < values.length; ++i )
		{
			final Object	idxValue	= values[ i ];
			
			boolean	matches	= false;
			
			if ( valueToMatch == null && idxValue == null )
			{
				matches	= true;
			}
			else if ( valueToMatch instanceof Class &&
					((Class<?>)valueToMatch).isAssignableFrom( idxValue.getClass() ) )
			{
				matches	= true;
			}
			else if ( valueToMatch != null && valueToMatch.equals( idxValue ) )
			{
				matches	= true;
			}
			else
			{
				// no match
			}
			
			if ( matches )
			{
				filtered.add( objectNames[ i ] );
			}
		}
		
		return( filtered );
	}
	
}


