/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/statistics/TimeStatisticImpl.java,v 1.4 2006/03/09 20:30:29 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:29 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;

import javax.management.j2ee.statistics.TimeStatistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;


/**
	
 */
public final class TimeStatisticImpl
	extends StatisticImpl implements TimeStatistic, Serializable
{
	static final long serialVersionUID = 1090185734375468511L;
	
	/* member names as defined by JSR 77 */
	private final long	Count;
	private final long	MinTime;
	private final long	MaxTime;
	private final long	TotalTime;
	
		public
	TimeStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	TimeStatisticImpl( final Map<String,?> m )
	{
		this( new MapStatisticImpl( m ) );
	}
	
		public
	TimeStatisticImpl( final TimeStatistic s )
	{
		super( s );
		
		Count		= s.getCount();
		MinTime		= s.getMinTime();
		MaxTime		= s.getMaxTime();
		TotalTime	= s.getTotalTime();
	}
	
		public
	TimeStatisticImpl( final MapStatistic s )
	{
		super( s );
		
		Count		= s.getlong( "Count" );
		MinTime		= s.getlong( "MinTime" );
		MaxTime		= s.getlong( "MaxTime" );
		TotalTime	= s.getlong( "TotalTime" );
	}
	
		public
	TimeStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final long		count,
		final long		maxTime,
		final long		minTime,
		final long		totalTime )
	{
		super( name, description, unit, startTime, lastSampleTime );
		Count		= count;
		MaxTime		= maxTime;
		MinTime		= minTime;
		TotalTime	= totalTime;
	}


 		public long
 	getCount()
 	{
 		return( Count );
 	}

 		public long
 	getMaxTime()
 	{
 		return( MaxTime );
 	}

 		public long
 	getMinTime()
 	{
 		return( MinTime );
 	}

 		public long
 	getTotalTime()
 	{
 		return( TotalTime );
 	}
}





