/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.misc;

import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import java.util.Locale;
import java.util.HashMap;
import java.util.Map;


import com.sun.appserv.management.util.misc.ClassUtil;

/**
	A StringSource for a package which first looks for a class in the the package
	named "PackageStringSource", and then, if not found, attempts to locate
	a ResourceBundle with the name "Strings".
	<p>
	Also maintains a cache of such sources so that subsequent uses reuse prior ones.
 */
public class PackageStringSources
{
	static final Map<Class,StringSource> mSources	= new HashMap<Class,StringSource>();
	
	/**
		Get a string source for the specified class, using the specified
		StringSource as its delegate.
	 */
		public static StringSource
	get( final Class theClass, final StringSource delegate )
	{
		StringSource	source	= mSources.get( theClass );
		if ( source == null )
		{
			source	= init( theClass, delegate );
			mSources.put( theClass, source );
		}

		return( source );
	}
	
	private PackageStringSources()	{}
	
		private static StringSource
	init( final Class theClass,  final StringSource delegate )
	{
		StringSource	source	= null;
		final String	packageName	= theClass.getPackage().getName();
		
		try
		{
			final String	classname	= packageName + ".PackageStrings";
			
			final Class	packageStringSourceClass	= ClassUtil.getClassFromName( classname );
			
			final Constructor	c	= packageStringSourceClass.getConstructor( new Class[] { StringSource.class } );
			
			source	= (StringSource)c.newInstance( new Object[] { delegate } );
		}
		catch( Exception e )
		{
			// no such class exists
			e.printStackTrace();
		}
		
		if ( source == null )
		{
			final ResourceBundle bundle	= ResourceBundle.getBundle( packageName + ".Strings",
										Locale.getDefault(), theClass.getClassLoader());
			
			source	= new ResourceBundleStringSource( bundle, delegate );
		}
		
		return( source );
	}
};



