/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: StringStatisticImpl.java,v 1.2 2005/12/25 03:52:27 tcfujii Exp $
 * $Date: 2005/12/25 03:52:27 $
 * $Revision: 1.2 $
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 * A basic implementation of the StringStatistic Interface. All the instances
 * of this class are immutable.
 * @author Muralidhar Vempaty
 * @author Kedar Mhaswade
 * @since S1AS8.0
 * @version 1.0
 */
public final class StringStatisticImpl extends StatisticImpl implements StringStatistic {
    
    private final String strVal;
    
    /** 
     * Constructor
     * @param str    The current value of this statistic
     * @param name      The name of the statistic
     * @param unit      The unit of measurement for this statistic
     * @param desc      A brief description of the statistic
     * @param startTime Time in milliseconds at which the measurement was started
     * @param sampleTime Time at which the last measurement was done.
     **/
    public StringStatisticImpl(String str, String name, String unit, 
                               String desc, long startTime, long sampleTime) {
        
        super(name, unit, desc, startTime, sampleTime);
        strVal = str;
    }
    
    /**
     * Returns the String value of the statistic.
     */
    public String getCurrent() {
        return strVal;
    }    
}
