/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.util.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * A proxy class
 */
public class ProxyClass implements InvocationHandler {

    private static InheritableThreadLocal
            callStackHolder = new InheritableThreadLocal() {
        protected synchronized Object initialValue() {
            return new CallStack();
        }
    };

    private static Logger _logger = getLogger();

    private Object delegate;
    private Interceptor interceptor;

    /** Creates a new instance of Proxy */
    public ProxyClass(Object handler, Interceptor interceptor) {
        delegate = handler;
        this.interceptor = interceptor;
    }
    
    public Object invoke(Object proxy, Method method, Object[] args)
            throws Throwable {
        Call call = new Call(method, args);
        CallStack callStack = (CallStack)callStackHolder.get();
        callStack.beginCall(call);
        try {
            interceptor.preInvoke(callStack);
        } catch (Throwable t) {
            _logger.log(Level.FINE, "core.interceptor_preinvoke_fail",
                    t.getMessage());
            _logger.log(Level.FINEST,
                    "core.interceptor_preinvoke_exception", t);
        }
        Object result = null;
        boolean success = true;
        Throwable failReason = null;
        try {
            result = method.invoke(delegate, args);
        } catch (InvocationTargetException ite) {
            success = false;
            failReason = ite.getTargetException();
            throw failReason;
        } catch (Throwable t) {
            success = false;
            failReason = t;
            throw failReason;
        } finally {
            if (!success) {
                call.setState(CallState.FAILED);
                call.setFailureReason(failReason);
            }
            call.setResult(result);
            
            if(!(call.getState().isFailed()))
                call.setState(CallState.SUCCESS);
            
            try {
                interceptor.postInvoke(callStack);
            } catch (Throwable t) {
                _logger.log(Level.FINE, "core.interceptor_postinvoke_fail",
                        t.getMessage());
                _logger.log(Level.FINEST,
                        "core.interceptor_postinvoke_exception", t);
            }
            callStack.endCall();
        }
        return result;
    }

    private static Logger getLogger() {
        String loggerName = System.getProperty("com.sun.aas.admin.logger.name");
        if (loggerName == null) {
            loggerName = "global";
        }
        return Logger.getLogger(loggerName);
    }
}
