/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.util.proxy;

import java.lang.reflect.Proxy;

/**
 *
 */
public class ProxyFactory {
    
    /** Creates a new instance of ProxyFactory */
    private ProxyFactory() {
    }

    public static Object createProxy(Class intfc, Object handler,
            Interceptor interceptor) {
        if (!intfc.isInterface()) {
            throw new IllegalArgumentException(intfc.getClass()
                    + " is not an interface");
        }
        if (!isImplementing(intfc, handler)) {
            throw new IllegalArgumentException("Handler object " + handler
                    + " is not an instance of " + intfc.getName());
        }
        Object obj = Proxy.newProxyInstance(
                handler.getClass().getClassLoader(),
                new Class[] {intfc},
                new ProxyClass(handler, interceptor));
        return obj;
    }

    private static boolean isImplementing(Class intfc, Object obj) {
        return intfc.isInstance(obj);
    }
}
