<%--
 The contents of this file are subject to the terms 
 of the Common Development and Distribution License 
 (the License).  You may not use this file except in
 compliance with the License.
 
 You can obtain a copy of the license at 
 https://glassfish.dev.java.net/public/CDDLv1.0.html or
 glassfish/bootstrap/legal/CDDLv1.0.txt.
 See the License for the specific language governing 
 permissions and limitations under the License.
 
 When distributing Covered Code, include this CDDL 
 Header Notice in each file and include the License file 
 at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 If applicable, add the following below the CDDL Header, 
 with the fields enclosed by brackets [] replaced by
 you own identifying information: 
 "Portions Copyrighted [year] [name of copyright owner]"
 
 Copyright 2006 Sun Microsystems, Inc. All rights reserved.
--%>

<%@ page info="peDiagReport" language="java" contentType="text/html; charset=UTF-8" %>
<%@taglib uri="/jato.tld" prefix="jato"%>
<%@taglib uri="/cc.tld" prefix="cc"%>

<jato:useViewBean type="com.iplanet.jato.view.ViewBean" className="peDiagReport">
<script language="JavaScript" src="../js/iasadmin.js"></script>
<SCRIPT language = "Javascript" >
function toggleDisabledState() {}

function disableTargetRB() {
    var clusterField = getFileField("peDiagReport.diagReport.cluster");
    var instanceField = getFileField("peDiagReport.diagReport.instance");
    var nodeAgentField = getFileField("peDiagReport.diagReport.nodeAgent");
    var targetClusterRB = document.getElementById("clusterTargetType");
    var targetInstanceRB = document.getElementById("instanceTargetType");
    var targetNodeAgentRB = document.getElementById("nodeAgentTargetType");
    var selectedTargetType = getSelectedValue("targetType");	
    
    if (clusterField.options.length == 0) {
        clusterField.disabled=true;
        targetClusterRB.disabled=true;
    } else {
        clusterField.disabled=false;
        targetClusterRB.disabled=false;
    }
    if (instanceField.options.length == 0) {
        instanceField.disabled=true;
        targetInstanceRB.disabled=true;
    } else {
        instanceField.disabled=false;
        targetInstanceRB.disabled=false;
    }
    if (nodeAgentField.options.length == 0) {
        nodeAgentField.disabled=true;
        targetNodeAgentRB.disabled=true;
    } else {
        nodeAgentField.disabled=false;
        targetNodeAgentRB.disabled=false;
    }
    
    if(selectedTargetType == 'domain') {
	clusterField.disabled=true;
	instanceField.disabled=true;
	nodeAgentField.disabled=true;
    } else if (selectedTargetType == 'cluster') {
	clusterField.disabled=false;
	instanceField.disabled=true;
	nodeAgentField.disabled=true;
	clusterField.focus();
    } else if (selectedTargetType == 'instance') {
        clusterField.disabled=true;
	instanceField.disabled=false;
	nodeAgentField.disabled=true;
	instanceField.focus();
    } else if (selectedTargetType == 'nodeagent') {
        clusterField.disabled=true;
	instanceField.disabled=true;
	nodeAgentField.disabled=false;
	nodeAgentField.focus();
    }
}

function setTargetField() {
    var targetField = getFileField("peDiagReport.diagReport.target");
    var domainField = getFileField("peDiagReport.diagReport.domain");
    var clusterField = getFileField("peDiagReport.diagReport.cluster");
    var instanceField = getFileField("peDiagReport.diagReport.instance");
    var nodeAgentField = getFileField("peDiagReport.diagReport.nodeAgent");
    var selectedTargetType = getSelectedValue("targetType");
    
    if(selectedTargetType == 'domain') {
	targetField.value = domainField.value;
    } else if (selectedTargetType == 'cluster') {
	targetField.value = clusterField.options[clusterField.selectedIndex].value;
    } else if (selectedTargetType == 'instance') {
        targetField.value = instanceField.options[instanceField.selectedIndex].value;
    } else if (selectedTargetType == 'nodeagent') {
        targetField.value = nodeAgentField.options[nodeAgentField.selectedIndex].value;
    } else {
        targetField.value = domainField.value;
    }
}

</SCRIPT>
<cc:header pageTitle="diagReport.PageTitle" copyrightYear="2005" name="HtmlHeader"
 baseName="com.sun.enterprise.tools.admingui.resources.Resources" bundleID="testBundle">

<!-- Form -->
<jato:form name="Form" method="post">

<jato:content name="resourceStrings">
msg.wait
diagReport.ConfirmMsg
</jato:content>

<!-- Bread Crumb component -->
<cc:breadcrumbs name="BreadCrumb" bundleID="testBundle" useGrayBg="true" />

<!-- Navigation Tabs -->
<cc:tabs name="ApplicationServerTabs" bundleID="testBundle" />

<div class="ConMgn">
<cc:alertinline name="Alert" bundleID="testBundle" />
</div>

<!-- Page Title --> 
<cc:pagetitle name="PageTitle" bundleID="testBundle"
 pageTitleText="diagReport.PageTitle" 
 showPageTitleSeparator="true"
 showPageButtonsTop="true"
 showPageButtonsBottom="true"
 pageTitleHelpMessage="diagReport.ConfidentialPropsHelp">

<!-- PropertySheet -->
<cc:propertysheet name="diagReport" bundleID="testBundle" addJavaScript="true"/>

<!-- Action Table -->
<cc:actiontable
 name="diagReportConfPropsTable"
 bundleID="testBundle"
 title="diagReport.ConfidentialProps"
 empty="diagReport.ConfidentialPropsEmpty"
 selectionJavascript="setTimeout('toggleDisabledState()', 0)"
 selectionType="no select"
 showAdvancedSortIcon="false"
 showLowerActions="true"
 showPaginationControls="true"
 showPaginationIcon="true"
 showSelectionIcons="false"
 showSelectionSortIcon="false"
 maxRows="25"
 page="1" />

<jato:content name="extra">
</jato:content>
</cc:pagetitle>
</jato:form>
</cc:header>
</jato:useViewBean>
