/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ViewXMLEntityResolver.java
 *
 * Created on December 9, 2003, 11:08 AM
 */

package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestManager;
//import com.sun.web.ui.model.CCDefaultEntityResolver;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;

/* This entity reolver looks for xml & dtd files that are included as SYSTEM entities
 * in the java class-path. If the xml file is not found in the class path the
 * resolver returns null, allowing default mechanism to search for the file
 * on the file system
 */

public class CCEntityResolver implements EntityResolver { //CCDefaultEntityResolver {
    public InputSource resolveEntity (String publicId, String systemId) {
        //System.out.print("CCEntityResolver: "+systemId);
        // Let Lockhart look for the entity first.
//        InputSource is = super.resolveEntity(publicId, systemId);
//        if (is != null) {
//            //System.out.println("BASE CLASS FOUND IT!!!!!);");
//            return is;
//        }
        if (systemId != null && (systemId.startsWith("http")==false) && 
            (systemId.endsWith(".xml") || systemId.endsWith(".dtd"))) {
            InputStream resourceStream = null;
            int i = systemId.indexOf("dtd/");
            if (i >= 0) {
                systemId = "xml/" + systemId.substring(i);
                //System.out.println("systemID: " + systemId);
                // First look in the classpath, the file maybe in a JAR
                resourceStream = getClass().getClassLoader()
                    .getResourceAsStream(systemId);
                if (resourceStream == null) {
                    // Next look in the app directory.
                    String sURL = "file:///" + 
                        RequestManager.getRequestContext().getServletContext()
                        .getRealPath(systemId);
                    //System.out.println("sURL: " + sURL);
                    try {
                        resourceStream = new URL(sURL).openStream();
                    } catch (Exception ex) {
                        //System.out.println(":::::::::::"+ex.getMessage());
                    }
                }
            }
            if (resourceStream != null) {
                return new InputSource(resourceStream);
            }
        }
        // use the default behaviour
        //System.out.println("CCEntityResolver: returning NULL");
        return null;
    }
}
