/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Date;
import java.util.Map;
import java.util.List;
import java.util.Properties;
import java.util.HashMap;
import java.text.DateFormat;
import java.text.NumberFormat;

import javax.faces.component.UIComponent;
import javax.management.Attribute;
import javax.management.AttributeList;

import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCOption;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.jsfext.component.ComponentUtil;

//need for constants
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.CallFlowMonitor;

import com.sun.web.ui.component.Tree;
import com.sun.web.ui.component.TreeNode;


public class CallFlowHandler {
    
    private static boolean PROVIDE_DEMO_DATA = false;
    private static String DEMO_INSTANCE_NAME = "demo";
    
    private static String SUCCESS="success";
    private static String FAILED="failed";
    private static String[] ADMIN_APP_PREFIX = 
        {"uri:/asadmin/",
         "uri:/admingui/",
         "uri:/images/",
         "uri:/js/",
         "uri:/redirect.html",
         "uri:/com_sun_web_ui/",
         "uri:/favicon.ico",
         "uri:/web1/"
         };
            
    private static final String LOCALHOST="127.0.0.1";
    private static final String END_TIMESTAMP_KEY = "end_timestamp";
   
  
    public void loadCallFlowDataTable(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	} else {
            DescriptorContainerView descView = (DescriptorContainerView)
                (((ViewBase)view).getParentViewBean());
            desc = descView.getViewDescriptor();
        }
        
        CCActionTableModelInterface model =(CCActionTableModelInterface)handlerCtx.getInputValue("model");
        if (model == null) {
            throw new FrameworkException("loadCallFlowDataTable: No Model Specified.",
                desc, handlerCtx.getView());
        }
        
        String instanceName = (String) handlerCtx.getInputValue("instanceName");
        String filterValue = (String) handlerCtx.getInputValue("filterValue");
        try {
            ((DefaultModel)model).clear();
            model.beforeFirst();
            model.setRowSelectionType("multiple");
            CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
            
            if (cfm == null)
                return;
            List listOfMap = cfm.queryRequestInformation ();
            if (listOfMap == null || listOfMap.isEmpty()){
                if (PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName))
                    listOfMap = queryDemoRequestInformation();
                else return;
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, ctx.getRequest().getLocale());
            Iterator it = listOfMap.iterator();
            while(it.hasNext()){
                Map oneRow = (Map) it.next();
                if( filterValue == null || includeRequest(oneRow, filterValue))
                    populateOneRow(model, oneRow, dateFormat);
            }
        } catch (Exception ex) {
            //backend shouldn't throw exception. 
            if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
        }
    }
    
    private void populateOneRow(CCActionTableModelInterface model, Map oneRow, DateFormat dateFormat){
        
        /* refer to bug# 6351555
         * Filtering out request thats from admin gui. 
         */
        String app = (String) oneRow.get(CallFlowMonitor.APPLICATION_NAME_KEY);
        if (!Util.isEmpty(app)){
            for(int i = 0; i < ADMIN_APP_PREFIX.length; i++){
                if (app.toLowerCase().startsWith(ADMIN_APP_PREFIX[i]))
                    return;
            }
        } 
        model.appendRow();
        String ms =(String) oneRow.get(CallFlowMonitor.TIME_STAMP_MILLIS_KEY);
        if (!Util.isEmpty(ms)){
            Date date = new Date (Long.parseLong (ms));
            String formattedTime = dateFormat.format(date);
            model.setValue("timeStampFormatted", formattedTime);
        }
        model.setValue("requestId", oneRow.get(CallFlowMonitor.REQUEST_ID_KEY));
        String clientHost = (String) oneRow.get(CallFlowMonitor.CLIENT_HOST_KEY);
        if (LOCALHOST.equals(clientHost))
            clientHost = Util.getMessage("CallFlow.localhost");
        model.setValue("clientHost", clientHost);
        model.setValue("user", oneRow.get(CallFlowMonitor.USER_KEY));
        model.setValue("application", oneRow.get(CallFlowMonitor.APPLICATION_NAME_KEY));
        model.setValue("startContainer", Util.getMessage((String)oneRow.get(CallFlowMonitor.REQUEST_TYPE_KEY)));
        String responseTime = (String)oneRow.get(CallFlowMonitor.RESPONSE_TIME_KEY);
        String resp = convertNanoToMs(responseTime);
        model.setValue("responseTime", resp);
        model.setValue("hiddenResponseTime", resp);
        String status = getStatus(oneRow);
        if (SUCCESS.equals(status))
            model.setValue("response", Util.getMessage("common.Success") );
        else
            model.setValue("response", Util.getMessage("common.Failed"));
    }
    
    
    public void populateFilterMenu(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        OptionList optionList = new OptionList();
        
        optionList.add(new CCOption(Util.getMessage("common.Success"), SUCCESS));
        optionList.add(new CCOption(Util.getMessage("common.Failed"), FAILED));
        optionList.add(new CCOption(Util.getMessage("REMOTE_WEB"), CallFlowMonitor.REMOTE_WEB));
        optionList.add(new CCOption(Util.getMessage("REMOTE_WEB_SERVICE"), CallFlowMonitor.REMOTE_WEB_SERVICE));
        optionList.add(new CCOption(Util.getMessage("REMOTE_EJB"), CallFlowMonitor.REMOTE_EJB));
        optionList.add(new CCOption(Util.getMessage("TIMER_EJB"), CallFlowMonitor.TIMER_EJB));
        optionList.add(new CCOption(Util.getMessage("REMOTE_ASYNC_MESSAGE"), CallFlowMonitor.REMOTE_ASYNC_MESSAGE));
        
        dropDownChild.setOptions(optionList);
    }


    /**
     *	<p> This handler is written for our JSF-based framework -- note the
     *	    HandlerContext package.  This method retreives the CallFlow stack
     *	    Maps.</p>
     *
     *	<p> This handler uses the following input:</p>
     *
     *	<ul><li><b>requestId</b> - The requestId of the CallFlow stack.</li>
     *	    <li><b>instanceName</b> - The server instance name.</li></ul>
     *
     *	<p> This handler returns the following output:</p>
     *
     *	<ul><li><b>callStackMap</b> - The Map of Maps representing the request
     *		information.</li></ul>
     *
     *	@param	handlerCtx  The JSF-based HandlerContext
     */
    public void getCallFlowStackMaps(com.sun.enterprise.tools.jsfext.event.handlers.HandlerContext handlerCtx) {

	String requestId = (String) handlerCtx.getInputValue("requestId");
	String instanceName = (String) handlerCtx.getInputValue("instanceName");

	CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
	if (cfm == null) {
	    return;
	}
	try {
	    List listOfMap = cfm.queryCallStackForRequest(requestId);
	    if (listOfMap==null || listOfMap.size()==0) {
		if (PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName)){
		    listOfMap = getDemoCallFlowStack(requestId);
		}
	    }
	    handlerCtx.setOutputValue("callStackMap", listOfMap);
	} catch (Exception ex) {
	    if (Util.isLoggableFINE()) {
		Util.logFINE(ex);
	    }
	}
    }

    /**
     *	<p> This handler is written for our JSF-based framework -- note the
     *	    HandlerContext package.  This method converts the CallFlow stack
     *	    List of Maps to tree and adds it as a child to the given parent
     *	    UIComponent.</p>
     *
     *	<p> This handler uses the following input:</p>
     *
     *	<ul><li><b>parent</b> -
     *		The <code>com.sun.web.ui.component.Tree</code>.</li>
     *	    <li><b>content</b> - The List of Maps.</li></ul>
     *
     *	<p> This handler returns the following output:</p>
     *
     *	<ul><li><b>tree</b> - The populated Tree.</li></ul>
     *
     *	@param	handlerCtx  The JSF-based HandlerContext
     */
    public void createCallFlowStackTree(com.sun.enterprise.tools.jsfext.event.handlers.HandlerContext handlerCtx) {
	// Get the inputs
	UIComponent parent = (UIComponent) handlerCtx.getInputValue("parent");
	List content = (List) handlerCtx.getInputValue("content");

	// Create a Tree dataSource...
	TreeDataSource dataSource = new CallFlowStackTreeDS(content);

	// Fill the Tree
	Tree tree = dataSource.createJSFTree(parent);

	// Set the output
	handlerCtx.setOutputValue("tree", tree);
    }

    private interface TreeDataSource {
	/**
	 *  <p>	This method is reponsible for creating, filling and adding a Tree
	 *	to the given parent UIComponent.  It will use the information
	 *	contained in this TreeDataSource.</p>
	 */
	public Tree createJSFTree(UIComponent parent);
    }

    private class CallFlowStackTreeDS implements TreeDataSource {
	public CallFlowStackTreeDS(List<Map> maps) {
	    if (maps != null) {
		_maps = maps;
	    }
	}

	/**
	 *  <p>	This method is reponsible for creating, filling and adding a Tree
	 *	to the given parent UIComponent.  It will use the information
	 *	contained in this TreeDataSource.</p>
	 */
	public Tree createJSFTree(UIComponent parent) {
	    Map nodeMap = null;
	    UIComponent child = null;
	    String type = null;
	    String methodName = null;
	    Tree tree = null;

	    // Get the interator...
	    Iterator<Map> it = _maps.iterator();
	    if (!it.hasNext()) {
		return null;
	    }
            
            //Get the application name from the methodStart row.
            String application = "";
            for(int i=0; i<_maps.size(); i++){
                Map ms = _maps.get(i);
                String rowType = (String) ms.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY);
                if(rowType.equals(CallFlowMonitor.CALL_STACK_METHOD_START )){
                    application = (String) ms.get(CallFlowMonitor.APPLICATION_NAME_KEY );
                    if(! Util.isEmpty(application))
                        break;
                }
            }
                    
	    // Process first Map (should be RequestStart)
	    nodeMap = (Map) it.next();
	    if (!((String) nodeMap.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY)).
		    equals(CallFlowMonitor.CALL_STACK_REQUEST_START)) {
		throw new RuntimeException("CallFlow stack should begin with "
			+ "RequestStart, instead got: '"
			+ nodeMap.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY) + "'.");
	    }
	    Properties props = new Properties();
	    props.put("expanded", Boolean.TRUE);
	    // ensure application is not null
	    if (application == null) application = "";
	    props.put("text", application);
	    //props.put("imageURL", ...);
	    child = ComponentUtil.getChild(parent, "callFlowTree",
		    "com.sun.enterprise.tools.jsfext.component.factory.basic.TreeFactory",
		    props);
	    parent.getChildren().add(child);
	    tree = (Tree) child;
	    tree.setClientSide(false);

	    int idx = 0;
	    while (it.hasNext()) {
		nodeMap = (Map) it.next();
		type = (String) nodeMap.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY);
		if (type.equals(CallFlowMonitor.CALL_STACK_METHOD_START)) {
		    parent = child;
		    methodName = (String) nodeMap.get(CallFlowMonitor.METHOD_NAME_KEY);
		    // Don't share properties...
		    props = (Properties) props.clone();
		    props.setProperty("text", methodName);
		    child = ComponentUtil.getChild(
			parent, "node" + (++idx),
			"com.sun.enterprise.tools.jsfext.component.factory.basic.TreeNodeFactory",
			props);
		    parent.getChildren().add(child);
		} else if (type.equals(CallFlowMonitor.CALL_STACK_METHOD_END)) {
		    // Set the child -- parent points to child on next pass
		    child = child.getParent();
		} else if (type.equals(CallFlowMonitor.CALL_STACK_REQUEST_END)) {
		    break;
		}
	    }

	    return tree;
	}

	/**
	 *  The List of Maps
	 */
	private List<Map> _maps = new ArrayList<Map>();
    }


public void getCallFlowDetail(RequestContext ctx, HandlerContext handlerCtx) {
    
    String requestId = (String) handlerCtx.getInputValue("requestId");
    String instanceName = (String) handlerCtx.getInputValue("instanceName");
    
    CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
    if (cfm == null)
        return;
    try {
        List listOfMap = cfm.queryCallStackForRequest (requestId);
        /*
        System.out.println("List returned by queryCallStackForRequest()");
        System.out.println(listOfMap);
        for(int i=0; i<listOfMap.size(); i++){
            System.out.println(" Map # " + i);
            System.out.println(listOfMap.get(i));
        }
         */
        if (listOfMap==null || listOfMap.size()==0){
            if (PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName)){
                listOfMap = getDemoCallFlowStack(requestId);
            }
        }
        Map oneRow = getRow( CallFlowMonitor.CALL_STACK_REQUEST_START, listOfMap);
        if(oneRow == null) return;  //shouldn't happen
        String ms =(String) oneRow.get(CallFlowMonitor.TIME_STAMP_MILLIS_KEY);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, ctx.getRequest().getLocale());
        Date date = new Date (Long.parseLong(ms));
        String formattedTime = dateFormat.format(date);
        handlerCtx.setOutputValue("timeStamp", formattedTime);

        handlerCtx.setOutputValue("startContainer", oneRow.get(CallFlowMonitor.REQUEST_TYPE_KEY));

        //extract info from METHOD_START
        oneRow = getRow( CallFlowMonitor.CALL_STACK_METHOD_START, listOfMap);
        if (oneRow == null) return;  //shouldn't happen
        handlerCtx.setOutputValue("application", oneRow.get(CallFlowMonitor.APPLICATION_NAME_KEY));
        //handlerCtx.setOutputValue("user", oneRow.get(CallFlowMonitor.USER_KEY));

        oneRow = getLastRow( CallFlowMonitor.CALL_STACK_METHOD_END, listOfMap);
        if(oneRow == null) return;
        String except = (String) oneRow.get(CallFlowMonitor.EXCEPTION_KEY);
        handlerCtx.setOutputValue("exception", except);
        handlerCtx.setOutputValue("callStackMap", listOfMap); 
    } catch (Exception ex) {
        if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
        }
    
}
    
    public void loadCallStackTable(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	} else {
            DescriptorContainerView descView = (DescriptorContainerView)
                (((ViewBase)view).getParentViewBean());
            desc = descView.getViewDescriptor();
        }
        CCActionTableModelInterface model =(CCActionTableModelInterface)handlerCtx.getInputValue("model");
        if (model == null) {
            throw new FrameworkException("loadCallFlowDataTable: No Model Specified.",
                desc, handlerCtx.getView());
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, ctx.getRequest().getLocale());
        try {
            ((DefaultModel)model).clear();
            model.beforeFirst();
            //model.setRowSelectionType("single");

            List listOfMap = (List) handlerCtx.getInputValue("callStackMap");
            if (listOfMap == null || listOfMap.isEmpty())
                return;
            ArrayList <Map>  tmpList = new ArrayList<Map> ();
            for(int i=0; i < listOfMap.size(); i++){
                Map oneRow = (Map) listOfMap.get(i);
                String type = (String) oneRow.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY);
                if (CallFlowMonitor.CALL_STACK_METHOD_START.equals(type)){
                    tmpList.add(oneRow);
                }
                if (CallFlowMonitor.CALL_STACK_METHOD_END.equals(type)){
                    int lastIndex = tmpList.size()-1;
                    Map methodStart = tmpList.get(lastIndex);
                    methodStart.put(END_TIMESTAMP_KEY, oneRow.get(CallFlowMonitor.TIME_STAMP_KEY) );
                    tmpList.remove(lastIndex);
                }
            }
            
            int sequence = 1;
            for(int i=0; i< listOfMap.size(); i++){
                Map oneRow = (Map) listOfMap.get(i);
                String type = (String) oneRow.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY);
                if (CallFlowMonitor.CALL_STACK_METHOD_START.equals(type))
                    populateOneDetailRow(model, oneRow, dateFormat, sequence++);
            }
        } catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
        }
    }
    
     private void populateOneDetailRow(CCActionTableModelInterface model, Map oneRow, DateFormat dateFormat, int sequence){
        model.appendRow();

        /*** Commented out for now, refer to bug# 6365274 
//        String startTime =(String) oneRow.get(CallFlowMonitor.TIME_STAMP_KEY);
//        String endTime = (String) oneRow.get(END_TIMESTAMP_KEY);
//        if (!Util.isEmpty(startTime) && !Util.isEmpty(endTime)){
//            String duration = String.valueOf(Long.parseLong(endTime) - Long.parseLong(startTime));
//            model.setValue("duration", convertNanoToMs(duration));
//        }
         */
        model.setValue("container", oneRow.get(CallFlowMonitor.CONTAINER_TYPE_KEY));
        model.setValue("module", oneRow.get(CallFlowMonitor.MODULE_NAME_KEY));
        model.setValue("method", oneRow.get(CallFlowMonitor.METHOD_NAME_KEY));
        model.setValue("component", oneRow.get(CallFlowMonitor.COMPONENT_NAME_KEY));
        model.setValue("sequence", sequence);
        //model.setValue("transaction", oneRow.get(CallFlowMonitor.TRANSACTION_ID_KEY));
        //model.setValue("thread", oneRow.get(CallFlowMonitor.THREAD_ID_KEY));
    }
    
     
  public void clearCallFlowData(RequestContext ctx, HandlerContext handlerCtx) {
        String instanceName = (String) handlerCtx.getInputValue("instanceName");
        if (Util.isEmpty(instanceName))
            throw new FrameworkException("CallFlowHandler:clearCallFlowData(): No instanceName specified");
        CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
        if (cfm == null)
            return;
        cfm.clearData() ;
  }
  
   public void setCallFlowConfig(RequestContext ctx, HandlerContext handlerCtx) {
       String instanceName = (String) handlerCtx.getInputValue("instanceName");
       Boolean enabled = new Boolean((String) handlerCtx.getInputValue("enabled"));
       String callerIpFilter = (String) handlerCtx.getInputValue("callerIpFilter");
       String callerPrincipalFilter = (String) handlerCtx.getInputValue("callerPrincipalFilter");
       CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
       if (cfm != null){
           cfm.setEnabled(enabled);
           cfm.setCallerIPFilter(callerIpFilter);
           cfm.setCallerPrincipalFilter(callerPrincipalFilter);
       }
   }
   
   
   public void getTimeSpendInfo(RequestContext ctx, HandlerContext handlerCtx) {
       String instanceName = (String) handlerCtx.getInputValue("instanceName");
       String requestId = (String) handlerCtx.getInputValue("requestId");
       CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
       if (cfm == null) return;
       try {
           Map timeSpendMap = (Map) cfm.queryPieInformation(requestId);
           if (timeSpendMap == null || timeSpendMap.size() <=0 ){
               if (PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName))
                    timeSpendMap = getDemoTimeSpendMap(requestId);
           }
           handlerCtx.setOutputValue("timeSpendMap", timeSpendMap); 
       }catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
        }
   }
   

   public void getTimeSpendValues(RequestContext ctx, HandlerContext handlerCtx) {
       Map<String, String> timeSpendMap = (Map<String, String>) handlerCtx.getInputValue("timeSpendMap");
       Boolean aa = Boolean.valueOf(timeSpendMap.containsKey("EJB_CONTAINER"));
       handlerCtx.setOutputValue("hasEjbContainer", aa);
       
       aa = Boolean.valueOf(timeSpendMap.containsKey("EJB_APPLICATION"));
       handlerCtx.setOutputValue("hasEjbApp", aa);
       
       aa = Boolean.valueOf(timeSpendMap.containsKey("WEB_CONTAINER"));
       handlerCtx.setOutputValue("hasWebContainer", aa);
       
       aa = Boolean.valueOf(timeSpendMap.containsKey("WEB_APPLICATION"));
       handlerCtx.setOutputValue("hasWebApp", aa);
       
       aa = Boolean.valueOf(timeSpendMap.containsKey("ORB_CONTAINER"));
       handlerCtx.setOutputValue("hasOrbContainer", aa);
       
       float total = 0;
       for(String key : timeSpendMap.keySet()){
           total += Float.parseFloat(timeSpendMap.get(key));
       }
       
       AttributeList attrsList = new AttributeList();
       for(String key : timeSpendMap.keySet()){
           String value = (String) timeSpendMap.get(key);
           float xx = Float.parseFloat(value);
           float yy = xx / total;
           float percent = yy * 100;
           NumberFormat numberformat = NumberFormat.getInstance();
           numberformat.setMinimumFractionDigits(2);
           Object[] args = {numberformat.format(percent), convertNanoToMs(value) };
           String result = Util.getMessage("callFlowDetail.percentMs", args);
           attrsList.add(new Attribute(key, result));
       }
       
       handlerCtx.setOutputValue("valueList", attrsList);
   }
   
   
    public void deleteCallFlowRequests(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
//        ((DefaultModel)model).dumpValues(System.out);
        ArrayList list = new ArrayList();
        model.setRowSelectionType("multiple");
        try{
            model.beforeFirst();
            while(model.next()) {
                boolean selected = model.isRowSelected();
                if (selected) {
                    String res = (String) model.getValue("requestId");
                    list.add(model.getValue("requestId"));
                    model.setRowSelected(false);
                }
            }
            if(!list.isEmpty()){
                String[] param = (String[]) list.toArray(new String[ list.size()]);
                CallFlowMonitor cfm = getCallFlowMonitor(instanceName);
                cfm.deleteRequestIDs(param);
            }
        }catch(Exception ex) {
            ex.printStackTrace();
	    throw new FrameworkException("Unable to delete CallFlow Requests: ", ex);
	}
    }
    
 
   private CallFlowMonitor getCallFlowMonitor(String instanceName){
        Map serverRootMonitorMap = AMXUtil.getDomainRoot().getMonitoringRoot().getServerRootMonitorMap();
        ServerRootMonitor serverRootMonitor = (ServerRootMonitor) serverRootMonitorMap.get(instanceName);
        //IF the instance is not running or when no monitorin on, just return;
        if (serverRootMonitor == null)
            return null;
        CallFlowMonitor cfm = serverRootMonitor.getCallFlowMonitor();
        return cfm;
   }
      
    private boolean includeRequest(Map oneRow, String filter){
        if (filter == null || "".equals(filter))
            return true;
        String status = getStatus(oneRow);
        String container = (String) oneRow.get(CallFlowMonitor.REQUEST_TYPE_KEY);
        
        if (filter.equalsIgnoreCase(status) ||  filter.equalsIgnoreCase(container))
            return true;
        else
            return false;
    }
    
    private String getStatus(Map oneRow){
        String error = (String) oneRow.get(CallFlowMonitor.EXCEPTION_KEY);
        return Util.isEmpty(error) ? SUCCESS : FAILED ;
        
    }
    
    private Map getRow(String callStackType, List listOfMap){
    
        Map oneRow = null;
        for(int i=0; i< listOfMap.size(); i++){
            oneRow = (Map) listOfMap.get(i);
            String type = (String) oneRow.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY);
            if (callStackType.equals(type))
                break;
        }
        return oneRow;
    }
    
    
    private Map getLastRow(String callStackType, List listOfMap){
        Map oneRow = null;
        for(int i= listOfMap.size()-1; i>=0;  i--){
            oneRow = (Map) listOfMap.get(i);
            String type = (String) oneRow.get(CallFlowMonitor.CALL_STACK_ROW_TYPE_KEY);
            if (callStackType.equals(type))
                break;
        }
        return oneRow;
    }
    
    private String convertFromNano(String ms, DateFormat dateFormat){
        long ns = Long.parseLong(ms);
        long ns1 = ns/1000000;
        Date dd = new Date(ns1);
        String formattedTime = dateFormat.format(dd);
        return formattedTime;
    }
    
    private String convertNanoToMs(String nano){
        
        float ns = Float.parseFloat(nano);
        float ns1 = ns / 1000000;
        NumberFormat numberformat = NumberFormat.getInstance();
        numberformat.setMinimumFractionDigits(2);
        String str = numberformat.format(ns1);
        return str;
    }
    
    
    private List queryDemoRequestInformation(){
        List listOfMap = new ArrayList();
        
        HashMap hashMap = new HashMap();
        hashMap.put(CallFlowMonitor.REQUEST_ID_KEY, "23458989" );
        hashMap.put(CallFlowMonitor.TIME_STAMP_KEY, ""+java.lang.System.nanoTime());
        hashMap.put(CallFlowMonitor.CLIENT_HOST_KEY, "138.243.150.122");
        hashMap.put(CallFlowMonitor.USER_KEY, "Mary");
        hashMap.put(CallFlowMonitor.REQUEST_TYPE_KEY, "web");
        hashMap.put(CallFlowMonitor.STATUS_KEY, "true");
        hashMap.put(CallFlowMonitor.RESPONSE_TIME_KEY, "34");
        hashMap.put(CallFlowMonitor.APPLICATION_NAME_KEY, "testApp");
        listOfMap.add(hashMap);
        
        HashMap hashMap2 = new HashMap();
        hashMap2.put(CallFlowMonitor.REQUEST_ID_KEY, "28881999" );
        hashMap2.put(CallFlowMonitor.TIME_STAMP_KEY, ""+java.lang.System.nanoTime());
        hashMap2.put(CallFlowMonitor.CLIENT_HOST_KEY, "138.243.140.111");
        hashMap2.put(CallFlowMonitor.USER_KEY, "Peter");
        hashMap2.put(CallFlowMonitor.REQUEST_TYPE_KEY, "ejb");
        hashMap2.put(CallFlowMonitor.STATUS_KEY, "true");
        hashMap2.put(CallFlowMonitor.RESPONSE_TIME_KEY, "69");
        hashMap2.put(CallFlowMonitor.APPLICATION_NAME_KEY, "testApp");
        listOfMap.add(hashMap2);
        
        HashMap hashMap3 = new HashMap();
        hashMap3.put(CallFlowMonitor.REQUEST_ID_KEY, "55551111" );
        hashMap3.put(CallFlowMonitor.TIME_STAMP_KEY, ""+java.lang.System.nanoTime());        
        hashMap3.put(CallFlowMonitor.CLIENT_HOST_KEY, "299.288.277.266");
        hashMap3.put(CallFlowMonitor.USER_KEY, "another-user");
        hashMap3.put(CallFlowMonitor.REQUEST_TYPE_KEY, "iiop");
        hashMap3.put(CallFlowMonitor.STATUS_KEY, "false");
        hashMap3.put(CallFlowMonitor.RESPONSE_TIME_KEY, "44");
        hashMap3.put(CallFlowMonitor.APPLICATION_NAME_KEY, "another-app");
        listOfMap.add(hashMap3);
        
        HashMap hashMap4 = new HashMap();
        hashMap4.put(CallFlowMonitor.REQUEST_ID_KEY, "38881999" );
        hashMap4.put(CallFlowMonitor.TIME_STAMP_KEY, ""+java.lang.System.nanoTime());
        hashMap4.put(CallFlowMonitor.CLIENT_HOST_KEY, "178.244.140.111");
        hashMap4.put(CallFlowMonitor.USER_KEY, "admin");
        hashMap4.put(CallFlowMonitor.REQUEST_TYPE_KEY, "ejb");
        hashMap4.put(CallFlowMonitor.STATUS_KEY, "false");
        hashMap4.put(CallFlowMonitor.RESPONSE_TIME_KEY, "20");
        hashMap4.put(CallFlowMonitor.APPLICATION_NAME_KEY, "testApp");
        listOfMap.add(hashMap4);
        
        return listOfMap;
    }
    
    private List getDemoCallFlowStack(String requestId){
        List listOfMap = new ArrayList();
        
        HashMap hMap = new HashMap();
        hMap.put("RequestID", "RequestID_1");
        hMap.put("RequestType", "REMOTE_EJB");
        hMap.put("TimeStamp", "10");
        hMap.put("CallStackRowType", "RequestStart");
        listOfMap.add(hMap);

        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("ModuleName", "Module_Name_1");
        hMap.put("MethodName", "Method_Name_1");
        hMap.put("Exception", "");
        hMap.put("ComponentName", "Component_Name_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("ApplicationName", "APP_NAME");
        hMap.put("ContainerType", "SERVLET");
        hMap.put("TimeStamp", "11");
        hMap.put("CallStackRowType", "MethodStart");
        listOfMap.add(hMap);


        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("ModuleName", "Module_Name_2");
        hMap.put("MethodName", "Method_Name_2");
        hMap.put("Exception", "");
        hMap.put("ComponentName", "Component_Name_2");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("ApplicationName", "APP_NAME");
        hMap.put("ContainerType", "SERVLET");
        hMap.put("TimeStamp", "12");
        hMap.put("CallStackRowType", "MethodStart");
        listOfMap.add(hMap);

        
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("Exception", "exe_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStamp", "13");
        hMap.put("CallStackRowType", "MethodEnd");
        listOfMap.add(hMap);

        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("Exception", "exe_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStamp", "14");
        hMap.put("CallStackRowType", "MethodEnd");
        listOfMap.add(hMap);

        hMap = new HashMap();
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStamp", "15");
        hMap.put("CallStackRowType", "RequestEnd");
        listOfMap.add(hMap);

        return listOfMap;
    }
    
    static int democount = 0;

    private Map getDemoTimeSpendMap(String id){
        
        HashMap hashMap = new HashMap();
        
        if (democount == 0){
        hashMap.put("WEB_CONTAINER", ""+10);
        hashMap.put("WEB_APPLICATION", ""+30);
        hashMap.put("EJB_CONTAINER", ""+15);
        hashMap.put("EJB_APPLICATION", ""+40);
        hashMap.put("ORB_CONTAINER", ""+5);
        }else
        if (democount == 1){
            hashMap.put("WEB_CONTAINER", ""+20);
            hashMap.put("WEB_APPLICATION", ""+10);
            hashMap.put("EJB_CONTAINER", ""+15);
            hashMap.put("EJB_APPLICATION", ""+30);
        }else
        if (democount == 2){
            hashMap.put("WEB_CONTAINER", ""+20);
            hashMap.put("WEB_APPLICATION", ""+10);
            hashMap.put("EJB_CONTAINER", ""+15);
        }
        else 
        {
            hashMap.put("WEB_CONTAINER", ""+20);
            hashMap.put("WEB_APPLICATION", ""+35);
        }
        if (democount++ >=3)
            democount=0;
        
        return hashMap;
    }
}
