/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DisplayItemMapper.java
 *
 * 
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.HashMap;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.deployment.util.XModuleType;
import javax.enterprise.deploy.shared.ModuleType;

public class DisplayItemMapper {
    
    
    final public static int MODULE_EAR = ModuleType.EAR.getValue();
    final public static int MODULE_EJB = ModuleType.EJB.getValue();
    final public static int MODULE_CAR = ModuleType.CAR.getValue();
    final public static int MODULE_RAR = ModuleType.RAR.getValue();
    final public static int MODULE_WAR = ModuleType.WAR.getValue();
    final public static int MODULE_LIFECYCLE = XModuleType.LCM.getValue(); 
    final public static int MODULE_MBEAN = XModuleType.CMB.getValue();
    
    public static HashMap displayItemMap, treeNodesMap;
    
    /* gets display item name for a given key */
    public void getDisplayItem(RequestContext ctx, HandlerContext handlerCtx) {
        if (displayItemMap == null) {
            initDisplayItemMap();
        }
        String displayItemName = 
            (String)displayItemMap.get((String)handlerCtx.getInputValue("key"));
        if (displayItemName == null)
            displayItemName = Util.getParentViewBean(handlerCtx.getView()).getName();
        handlerCtx.setOutputValue("displayItem", displayItemName);
    }    

    public void getTreeNode(RequestContext ctx, HandlerContext handlerCtx) {
        if (displayItemMap == null) {
            initDisplayItemMap();
        }
        String nodeName = 
            (String)treeNodesMap.get((String)handlerCtx.getInputValue("key"));
        handlerCtx.setOutputValue("nodeName", nodeName);
    }    
    
    private static void initDisplayItemMap() {
        displayItemMap = new HashMap();
        displayItemMap.put("cluster", "cluster");
        displayItemMap.put("server", "serverInstance");
        displayItemMap.put("mail-resource", "javaMailSessionsEdit");
        displayItemMap.put("jdbc-resource", "jdbcResourcesEdit");
        displayItemMap.put("admin-object-resource", "adminObjectResourceEdit");
        displayItemMap.put("connector-resource", "connectorResourceEdit");
        displayItemMap.put("custom-resource", "customResourcesEdit");
        displayItemMap.put("external-jndi-resource", "externalResourcesEdit");
        displayItemMap.put("jdbc-connection-pool", "connectionPoolResourcesEdit");
        displayItemMap.put("connector-connection-pool", "connectorConnectionPoolEdit");
        
	displayItemMap.put("ear", "enterpriseApplicationsEdit");
	displayItemMap.put("war", "webApplicationsEdit");
	displayItemMap.put("ejb", "ejbModulesEdit");
	displayItemMap.put("rar", "connectorModulesEdit");
	displayItemMap.put("car", "appclientModulesEdit");
        displayItemMap.put("lifecycle", "lifecycleModulesEdit");
        displayItemMap.put("mbean", "customMBeansEdit");
        
        
        /* this is a hack - should be fixed after ModuleType is available from deployment api */
	displayItemMap.put(""+MODULE_EAR, "enterpriseApplicationsEdit");
	displayItemMap.put(""+MODULE_WAR, "webApplicationsEdit");
	displayItemMap.put(""+MODULE_EJB, "ejbModulesEdit");
	displayItemMap.put(""+MODULE_RAR, "connectorModulesEdit");
	displayItemMap.put(""+MODULE_CAR, "appclientModulesEdit");
        displayItemMap.put(""+MODULE_LIFECYCLE, "lifecycleModulesEdit");
        displayItemMap.put(""+MODULE_MBEAN, "customMBeansEdit");
        
       
        treeNodesMap = new HashMap();
        treeNodesMap.put("cluster", "clusters");
        treeNodesMap.put("serverInstance", "standAloneInstances");
        treeNodesMap.put("jdbcResourcesEdit", "jdbcResources");
        treeNodesMap.put("javaMailSessionsEdit", "javaMailSessions");
        treeNodesMap.put("adminObjectResourceEdit", "adminObjectResources");
        treeNodesMap.put("connectorResourceEdit", "connectorResources");
        treeNodesMap.put("customResourcesEdit", "customResources");
        treeNodesMap.put("externalResourcesEdit", "externalResources");
        treeNodesMap.put("connectionPoolResourcesEdit", "connectionPoolResources");
        treeNodesMap.put("connectorConnectionPoolEdit", "connectorConnectionPools");
        
        treeNodesMap.put("enterpriseApplicationsEdit", "enterpriseApplications");
	treeNodesMap.put("webApplicationsEdit", "webApplications");
	treeNodesMap.put("ejbModulesEdit", "ejbModules");
	treeNodesMap.put("connectorModulesEdit", "connectorModules");
	treeNodesMap.put("appclientModulesEdit", "appclientModules");
        treeNodesMap.put("lifecycleModulesEdit", "lifecycleModules");
        treeNodesMap.put("customMBeansEdit", "customMBeans");
    }
    
}
