/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MsgSecurityConfigHandler.java
 *
 * Created on June 6, 2004, 8:08 AM
 */

package com.sun.enterprise.tools.admingui.handlers;


import java.util.Map;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.RequestContext;

import javax.management.Attribute;
import javax.management.AttributeList;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.Util;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;

/**
 *
 * @author  anilam
 */
public class MsgSecurityConfigHandler {
    
    /**
     *	This method creates the message-security-config element together with the provider-config
     *  which is required.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void createMessageSecurityProvider(RequestContext reqCtx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String configName = (String)handlerCtx.getInputValue("configName");
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        String isDefaultProvider = (String)handlerCtx.getInputValue("isDefaultProvider");
        Object providerProperties = handlerCtx.getInputValue("providerProperties");
        AttributeList providerAttr = (AttributeList)handlerCtx.getInputValue("providerAttr");
	AttributeList requestAttr = (AttributeList)handlerCtx.getInputValue("requestAttr");
	AttributeList responseAttr = (AttributeList)handlerCtx.getInputValue("responseAttr");
	
        if (objectName == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain objectName");
	}
	try {
            String providerId = getAttrValue( providerAttr, "provider-id");
            String providerType = getAttrValue( providerAttr, "provider-type");
            String className = getAttrValue( providerAttr, "class-name");
            
            String requestAuthSource = getAttrValue( requestAttr, "auth-source");
            String requestRecipient = getAttrValue( requestAttr, "auth-recipient");
            
            String responseAuthSource = getAttrValue( responseAttr, "auth-source");
            String responseRecipient = getAttrValue( responseAttr, "auth-recipient");
            
            if(Util.isEmpty(requestAuthSource)) requestAuthSource = null;
            if(Util.isEmpty(requestRecipient)) requestRecipient = null;
            if(Util.isEmpty(responseAuthSource)) responseAuthSource = null;
            if(Util.isEmpty(responseRecipient)) responseRecipient = null;
            
            Object[] params = new Object[] {
                msgSecurityName,    // auth-layer attribute of message-security-config
                providerId,   // provider id
                providerType, // "client"/"server"/"client-server"
                className,    // The class-name of java class  of the provider.
                requestAuthSource,  //requestAuthSource
                requestRecipient,  //requestAuthRecipient
                responseAuthSource,  //responseAuthSource
                responseRecipient,  //responseAuthRecipient
                new Boolean(isDefaultProvider),  // set pro
                providerProperties,  //provider's properties
                configName  //requestAuthSource
            };
            
            String[] types = new String[] {
            "java.lang.String", 
            "java.lang.String", 
            "java.lang.String", 
            "java.lang.String", 
            "java.lang.String", 
            "java.lang.String", 
            "java.lang.String", 
            "java.lang.String", 
            "boolean", 
            "java.util.Properties", 
            "java.lang.String"
            };
        
            /*
            System.out.println("========= MsgSecurityConfigHandler ======");
            System.out.println("objectName=" + objectName);
            for(int i=0; i<params.length; i++){
                System.out.println( i + " : " + params[i]);
            }
             */
            MBeanUtil.invoke(
		objectName, 
		"createMessageSecurityProvider", 
		params,
		types);
	} catch (Exception ex) {
	    throw new FrameworkException(
		"Error while calling createMessageSecurityProvider() on MBean '"+objectName+
		"'!", ex, handlerCtx.getViewDescriptor(),
		handlerCtx.getView());
	}
    }
    
    
    private String getAttrValue(AttributeList attrList, String attrName){
        if (attrList == null)
            return null;
        for (int i=0; i < attrList.size(); i++) {
            Attribute attr = (Attribute) attrList.get(i);
                String name  = attr.getName();
                if(attrName.equals(name))
                    return attr.getValue().toString();
        }
        return null;
    }

    
    /**
     *	This method modifies the request-policy and response-policy.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void saveRequestAndResponsePolicy(RequestContext reqCtx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        AttributeList requestAttr = (AttributeList)handlerCtx.getInputValue("requestAttr");
        AttributeList responseAttr = (AttributeList)handlerCtx.getInputValue("responseAttr");
        boolean requestExist = ((Boolean)handlerCtx.getInputValue("requestExist")).booleanValue();
        boolean responseExist = ((Boolean)handlerCtx.getInputValue("responseExist")).booleanValue();
        
	if (objectName == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain objectName");
	}
        try {
            savePolicy(objectName, responseAttr, responseExist, "removeResponsePolicy", "createResponsePolicy");
            savePolicy(objectName, requestAttr, requestExist, "removeRequestPolicy", "createRequestPolicy");
        }catch (Exception ex) {
            throw new FrameworkException(
                "Error while calling saveRequestAndResponsePolicy() on MBean '"+objectName+
                "'!", ex, handlerCtx.getViewDescriptor(),
                handlerCtx.getView());
        }
    }
    
     public Boolean testNewButtonAllowed(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue("value");
        if (value == null)
            return TRUE;
        if (value instanceof Object[]){
            if  (((Object[])value).length < 2) 
                return TRUE;
        }
        // WE are just testing for the # of msg security config, assume that no more than 1 will have the same layer (SOAP or HttpServlet)
        //Can add more test here if we want.
        return FALSE;
     }
        
     
     public void popularMsgLayerAllowed(RequestContext reqCtx, HandlerContext handlerCtx) {
         // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();
        
        // need the child descriptor to get a parameter, retrieve from the parent descriptor.
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(dropDownChild.getName());
        
        String configName = (String) handlerCtx.getInputValue("configName");
        Map cmap = (Map) AMXUtil.getDomainConfig().getConfigConfigMap();
        SecurityServiceConfig ssc =  ((ConfigConfig) cmap.get(configName)).getSecurityServiceConfig();
        Map msgSCMap = ssc.getMessageSecurityConfigMap();
        boolean hasSOAP = false;
        boolean hasHttpServlet = false;
        int count = 2;
        
        if (msgSCMap != null ){
            if (msgSCMap.get("SOAP") != null){
                hasSOAP=true;
                count--;
            }
            if (msgSCMap.get("HttpServlet") != null){
                hasHttpServlet=true;
                count--;
            }
        }
        String[] options = null;
        
        if (count == 0) //should never happen 
            return;
        if (count == 2){
            options = new String[] {"SOAP", "HttpServlet"};
        }else 
        if (count == 1){
            if (hasSOAP) 
                options = new String[] { "HttpServlet"};
            else 
                options = new String[] {"SOAP"};

        }
        OptionList optionList = new OptionList(options, options);
        dropDownChild.setOptions(optionList);
     }
     
    
    private void savePolicy(String objectName, AttributeList attrs, boolean exist, String removeMethod, String createMethod) 
    {
        boolean hasValue = attrHasValue(attrs);
        if (hasValue){
            if (exist){
                MBeanUtil.invoke(objectName, removeMethod, null, null);
            }
            Object[] params = new Object[] {attrs};
            String[] types = new String[] {"javax.management.AttributeList" };
            MBeanUtil.invoke( objectName, createMethod, params, types);
            return;
        }else{
            if(exist){
               MBeanUtil.invoke(objectName, removeMethod, null, null);
            }
        }
    }
    
    private boolean attrHasValue(AttributeList attrList){
        for (int i=0; i < attrList.size(); i++) { 
            Attribute attr = (Attribute) attrList.get(i); 
            if (hasValue(attr.getValue().toString()))
                return true;
        }
        return false;
    }
    
    private boolean hasValue(String val){
        return (val != null) && !"".equals(val);
    }
    
     /**
     *	FALSE
     */
    public static final Boolean FALSE = new Boolean(false);

    /**
     *	TRUE
     */
    public static final Boolean TRUE = new Boolean(true);
}
