/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.handlers.DeploymentHandler;
import com.sun.enterprise.tools.admingui.handlers.WebServiceHandler;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import com.sun.enterprise.tools.admingui.util.FileUtil;

import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.util.misc.ExceptionUtil;


/**
 *
 */
public class UploadServlet extends HttpServlet {
    //Need to remove maxUploadSize after testing MultipartHandler properly.
    //Right now leaving it here, but not using it anywhere.
    private static final String CFG_MAX_UPLOAD_SIZE = "maxUploadSize";
    private static final int MAX_UPLOAD_SIZE = 10 * 1024 * 1024; // 10 Meg
    private static final String CURRENT = "current";
    private static final String NEXT = "next";
    int maxUploadSize = MAX_UPLOAD_SIZE;
    ServletContext ctxt = null;
    String mesg = null;
    String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
    
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ctxt = getServletContext();
    }
    
    protected void doPost(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException {
        String uploadType = req.getParameter("uploadType");
        String appType = req.getParameter("appType");
        String which = req.getParameter("which");
        String cancelPage = req.getParameter("cancelPage");
        
        res.setContentType("text/html; charset=UTF-8");
        PrintWriter out = res.getWriter();
        String contentType = req.getContentType();
        String uploadDir = null;
        String uploadDirErrMsg = "";
        String dispatchRequest = null;
        
        
        
        if("mbean".equals(appType) && !(which.equals("client"))){
            //if its create mbean from jar in server side, no need to upload, just extract and test implClass.
        }else{
            try {
                uploadDir = FileUtil.getUploadDir();
            } catch(SecurityException se) {
                uploadDirErrMsg = Util.getMessage("upload.permission");
                se.printStackTrace();
            } catch(Exception e) {
                if (uploadType==null) {
                    uploadDirErrMsg = Util.getMessage("upload.UploadTypeNotSpecified");
                }
                e.printStackTrace();
            }
        }
        
        if (contentType.toLowerCase().startsWith("multipart/form-data")) {
            if ((uploadDir == null) && Util.isLoggableCONFIG()) {
                Util.logCONFIG("UploadServlet.doPost: uploadDir is null. " + uploadDirErrMsg);
	    }
            if (uploadDir == null) {
                if (Util.isLoggableWARNING()) {
                    Util.logWARNING(Util.getMessage("upload.ErrorUploadingFile")
                    + Util.getMessage("upload.nullDir")
                    + Util.getMessage(uploadDirErrMsg));
                }
                req.setAttribute("ALERT_TYPE","error");
                req.setAttribute("ALERT_SUMMARY", "upload.nullDir");
                req.setAttribute("MBEAN_MESSAGE", uploadDirErrMsg);
                req.setAttribute("HAS_MBEAN_MESSAGE", "true");
                req.setAttribute("HAS_ERROR_MESSAGE", "true");
                if (cancelPage!=null && !cancelPage.equals("")){
                    req.setAttribute("cancelPage", cancelPage);
                }
                dispatchRequest = getDispatchRequest(uploadType, appType, CURRENT);
            } else {
                MultipartHandler multiReq = new MultipartHandler(req, uploadDir, maxUploadSize);
                multiReq.parseMultipartUpload();
            
                Enumeration fileEnum = multiReq.getFileNames();     
                String name = (String)fileEnum.nextElement();
                File appFile = multiReq.getFile(name);
                String appFileName = appFile.getAbsolutePath();
                long len = appFile.length();
                if (len > 0) {
                    dispatchRequest = getDispatchRequest(uploadType, appType, NEXT);
                    String filePath = appFile.getAbsolutePath();
                    String fileName = getFileName(filePath);
                    if (dispatchRequest != null) {
                        if (uploadType.equals(FileUtil.DEPLOY)) {
                            
                            String listPage = multiReq.getParameter("upload.listPage");
                            req.setAttribute("filePath", filePath);
                            req.setAttribute("fileName", getFileName(filePath));
                            req.setAttribute("uploadedFileName", appFile.getName());
                            req.setAttribute("ctxtRoot", "/"+fileName);
                            if (cancelPage!=null && !cancelPage.equals("")){
                                req.setAttribute("cancelPage", cancelPage);
                            }
                            if (listPage != null && !listPage.equals("")){
                                req.setAttribute("listPage", listPage);
                            }
                            if ("mbean".equals(appType)){
                                if(!testMbeanExist(req, filePath)){
                                    dispatchRequest = getDispatchRequest(FileUtil.DEPLOY, appType, CURRENT);
                                }
                            }
                        } else if (uploadType.equals(FileUtil.REDEPLOY)) {
                            if (!redeploy(req, true, filePath)) {
                                dispatchRequest = getDispatchRequest(FileUtil.REDEPLOY, appType, CURRENT);
                            }
                        } else if (uploadType.equals(FileUtil.TRANSFORMATION_RULE)) {
                            if (!addTransformationRule(req, filePath)) {
                                dispatchRequest = getDispatchRequest(FileUtil.TRANSFORMATION_RULE, appType, CURRENT);
                            }
                        }
                    }
                } else {
                    req.setAttribute("AppType", appType);
                    req.setAttribute("ALERT_TYPE","error");
                    req.setAttribute("ALERT_SUMMARY", "upload.ErrorUploadingFile");
                    req.setAttribute("MBEAN_MESSAGE", "upload.FileToUploadDoesNotExist");
                    req.setAttribute("HAS_MBEAN_MESSAGE", "true");
                    req.setAttribute("HAS_ERROR_MESSAGE", "true");
                    if (cancelPage!=null && !cancelPage.equals("")){
                        req.setAttribute("cancelPage", cancelPage);
                    }
                    dispatchRequest = getDispatchRequest(uploadType, appType, CURRENT);
                }
            }
        } else if (contentType.toLowerCase().startsWith("application/x-www-form-urlencoded")) {
            dispatchRequest = getDispatchRequest(uploadType, appType, NEXT);
            if (uploadType.equals(FileUtil.REDEPLOY)) {
                if (!redeploy(req, false, null)) {
                    dispatchRequest = getDispatchRequest(FileUtil.REDEPLOY, appType, CURRENT);
                }
            }else
            if ("mbean".equals(appType)){
                if(!testMbeanExist(req, null)){
                    dispatchRequest = getDispatchRequest(FileUtil.DEPLOY, appType, CURRENT);
                }
            }
        } else {
            dispatchRequest = getDispatchRequest(uploadType, appType, NEXT);
        }
        
        try {
            req.getRequestDispatcher(dispatchRequest).forward(req, res);
        }
        catch(Exception e) {
            ctxt.log(e.getMessage()+" "+e.getClass());
        }
    }
    
    private String getDispatchRequest(String uploadType, String appType, String page) {
        String dispatchRequest = null;
        if (page.equals(CURRENT)) {
            if (uploadType.equals(FileUtil.DEPLOY)) {
                dispatchRequest = "../admingui/upload";
            } else if (uploadType.equals(FileUtil.REDEPLOY)) {
                dispatchRequest = "../admingui/redeploy";
            } else if (uploadType.equals(FileUtil.TRANSFORMATION_RULE)) {
                dispatchRequest = "../admingui/webServiceTransformationAdd";
            }
        } else if (page.equals(NEXT)) {
            boolean isEAR = false;
            boolean isWAR = false;
            boolean isEJB = false;
            boolean isRAR = false;
            boolean isAC = false;
            boolean isMBean = false;
            if (appType != null) {
                if (appType.equals("ear")) {
                    isEAR = true;
                } else if (appType.equals("war")) {
                    isWAR = true;
                } else if (appType.equals("jar")) {
                    isEJB = true;
                } else if (appType.equals("rar")) {
                    isRAR = true;
                } else if (appType.equals("all")) {
                    isAC = true;
                } else if (appType.equals("mbean")) {
                    isMBean = true;
                }
            }
            if (uploadType.equals(FileUtil.DEPLOY)) {
                if(isWAR) {
                    dispatchRequest = "../admingui/deployWebModule";
                } else if(isEAR) {
                    dispatchRequest = "../admingui/deployJ2EEApplication";
                } else if(isEJB) {
                    dispatchRequest = "../admingui/deployEJBJarModule";
                } else if(isRAR) {
                    dispatchRequest = "../admingui/deployConnectorModule";
                } else if(isAC) {
                    dispatchRequest = "../admingui/deployAppclientModule";
                } else if(isMBean) {
                    dispatchRequest= "../admingui/createCustomMBean";
                }
            } else if (uploadType.equals(FileUtil.REDEPLOY)) {
                Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
                if(isWAR) {
                    if (isTargetSupported.booleanValue()) {
                        dispatchRequest = "../admingui/eeWebApplications";
                    } else {
                        dispatchRequest = "../admingui/webApplications";
                    }
                } else if(isEAR) {
                    if (isTargetSupported.booleanValue()) {
                        dispatchRequest = "../admingui/eeEnterpriseApplications";
                    } else {
                        dispatchRequest = "../admingui/enterpriseApplications";
                    }
                } else if(isEJB) {
                    if (isTargetSupported.booleanValue()) {
                        dispatchRequest = "../admingui/eeEjbModules";
                    } else {
                        dispatchRequest = "../admingui/ejbModules";
                    }
                } else if(isRAR) {
                    if (isTargetSupported.booleanValue()) {
                        dispatchRequest = "../admingui/eeConnectorModules";
                    } else {
                        dispatchRequest = "../admingui/connectorModules";
                    }
                } else if(isAC) {
                    if (isTargetSupported.booleanValue()) {
                        dispatchRequest = "../admingui/eeAppclientModules";
                    } else {
                        dispatchRequest = "../admingui/appclientModules";
                    }
                }
            } else if (uploadType.equals(FileUtil.TRANSFORMATION_RULE)) {
                dispatchRequest = "../admingui/webServiceTransformation";
            }
        }
        return dispatchRequest;
    }
    
    
   
                            
                            
    private boolean redeploy(HttpServletRequest req, boolean isUpload, String uploadFile) {
        boolean isRedeploySuccessful = false;
        String location = req.getParameter("AppFile");
        String type = req.getParameter("appType");
        String contextRoot = req.getParameter("contextRoot");
        if (isUpload) {
            location = uploadFile;
        } else {
            location = req.getParameter("DirectoryDeployField");
        }
        String n = req.getParameter("name");
        Properties props = new Properties();
        props.setProperty(DeploymentProperties.ARCHIVE_NAME, location);
        props.setProperty(DeploymentProperties.NAME, n);
        props.setProperty(DeploymentProperties.FORCE, "true");
        props.setProperty(DeploymentProperties.CONTEXT_ROOT, contextRoot);
            
        String errMsg = null;
         //our framework needs these attrs. to display the error mesg.
        req.setAttribute("AppType", type);
        req.setAttribute("HAS_MBEAN_MESSAGE", "true");
        try {
            DeploymentHandler.invokeDeploymentFacility(null, props, location);
            isRedeploySuccessful = true;
            req.setAttribute("ALERT_TYPE","info");
            req.setAttribute("ALERT_SUMMARY", "redeploy.successful");
            req.setAttribute("MBEAN_MESSAGE", "");
            req.setAttribute("infoAlert", "true");
        } catch (Exception e) {
            isRedeploySuccessful = false;
            errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = Util.getMessage(bundle, "alert.SeeServerLog", null);
            }
            req.setAttribute("ALERT_TYPE","error");
            req.setAttribute("ALERT_SUMMARY", "alert.Summary");
            req.setAttribute("MBEAN_MESSAGE", errMsg);
            req.setAttribute("HAS_ERROR_MESSAGE", "true");
        }
        return isRedeploySuccessful;
    }
    
    private boolean addTransformationRule(HttpServletRequest req, String uploadDir) {
        boolean isAddRuleSuccessful = false;
        String clientLocation = req.getParameter("RuleFile");
        File f = new File(clientLocation);
        String errMsg = null;
        String ruleName = req.getParameter("ruleName");
        String webServiceKey = (String)req.getParameter("webServiceKey");
        webServiceKey = webServiceKey.replaceAll("[@]","#");
        String applyTo = req.getParameter("applyTo");
        boolean enabled = Boolean.valueOf(req.getParameter("enabled")).booleanValue();
        try {
            WebServiceMgr wsm = (WebServiceMgr)AMXUtil.getDomainRoot().getWebServiceMgr();
            WebServiceHandler.createTransformationRuleConfig(webServiceKey, ruleName, enabled, applyTo, uploadDir, null);
            isAddRuleSuccessful = true;
        } catch (Exception e) {
            isAddRuleSuccessful = false;
            Throwable t = ExceptionUtil.getRootCause(e);
            if (t != null) {
                errMsg = t.getLocalizedMessage();
		if (errMsg == null) {
		    errMsg = t.getMessage();
		}
            }
            if (errMsg == null) {
                errMsg = Util.getMessage(bundle, "alert.SeeServerLog", null);
            }
            //our framework needs these attrs. to display the error mesg.
            req.setAttribute("ALERT_TYPE","error");
            req.setAttribute("ALERT_SUMMARY", "alert.Summary");
            req.setAttribute("MBEAN_MESSAGE", errMsg);
            req.setAttribute("HAS_MBEAN_MESSAGE", "true");
            req.setAttribute("HAS_ERROR_MESSAGE", "true");
        }
        return isAddRuleSuccessful;
    }
    
    //After uploading the jar that contains the mbean class to the server, we also need to 
    //extract the jar to applications/mbean directory.
    private boolean testMbeanExist(HttpServletRequest req, String jarFileName){
        
        String errMsg = "";
        try {
            String which = req.getParameter("which");
            String implClass = req.getParameter("implClass");
            req.setAttribute("implClass", implClass);
            String domainRoot = Util.getDomainRoot();
            
            if(which.equals("server")){
                jarFileName = req.getParameter("DirectoryDeployField");
                FileUtil.extractMbeanJarFile(domainRoot, jarFileName);
                req.setAttribute("uploadedFileName", jarFileName);
                req.setAttribute("implClass", implClass);
                String nm = new File(jarFileName).getName();
                int index = nm.indexOf(".");
                if (index > 0) nm = nm.substring(0, index);
                req.setAttribute("fileName", nm);
                String listPage = req.getParameter("upload.listPage");
                if (listPage != null && !listPage.equals("")){
                        req.setAttribute("listPage", listPage);
                }
            }else
            if (which.equals("skip")){
                req.setAttribute("implClass", implClass);
//                req.setAttribute("uploadedFileName", Util.getMessage("common.NA"));
                req.setAttribute("uploadedFileName", Util.getMessage(bundle, "common.NA", null));
                String listPage = req.getParameter("upload.listPage");
                if (listPage != null && !listPage.equals("")){
                        req.setAttribute("listPage", listPage);
                }
            }else
            if(which.equals("client")){
                FileUtil.extractMbeanJarFile(domainRoot, jarFileName);   
            }
            
            Object[] params = {implClass};
            String[] types = {"java.lang.String"};
            MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getMBeanInfo", params, types);
                   
            return true;
        }catch(IOException ioEx){
            errMsg = ioEx.getMessage(); 
            
        }catch (Exception ex){
            if (ex.getCause() == null){
                errMsg = ex.getLocalizedMessage();
            }else {
                errMsg = ex.getCause().getLocalizedMessage();
            }
        }
        req.setAttribute("AppType", "mbean");
        //our framework needs these attrs. to display the error mesg.
        req.setAttribute("ALERT_TYPE","error");
        req.setAttribute("ALERT_SUMMARY", "alert.Summary");
        req.setAttribute("MBEAN_MESSAGE", errMsg);
        req.setAttribute("HAS_MBEAN_MESSAGE", "true");
        req.setAttribute("HAS_ERROR_MESSAGE", "true");
        return false;
    }
    
    private String getFileName(String filePath) {
        String name = new File(filePath).getName();
        int index = name.indexOf(".");
        if (index > 0)
            return name.substring(0, index);
        else 
            return filePath;
    }
    
}
