/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.taglib;

import com.iplanet.jato.*;
import com.iplanet.jato.model.*;
import com.iplanet.jato.view.*;
import com.iplanet.jato.view.html.*;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCPropertySheetModel;

import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.xml.parsers.*;


public class DataSheetModel extends CCPropertySheetModel 
                            implements DataSheetModelInterface {
    /**
     * Default constructor.
     */
    public DataSheetModel() {
	super();
    }

    /**
     * Construct an instance from the given string containing XML data.
     *
     * @param value The string containing XML data.
     */
    public DataSheetModel(String value) {
        super(value);
    }
    
    /**
     * Construct an instance from an XML file, identified by path name
     * the the servlet context.
     *
     * @param sc The servlet context used to retrieve file.
     * @param value The path to a file, relative to the application
     * base directory (e.g., /WEB-INF/table.xml).
     */
    public DataSheetModel(ServletContext sc, String file) {
        super(sc, file);
    }
    
    /**
     * Construct an instance from the given InputStream containing XML data.
     *
     * NOTE: You must call the setDocument(is) after deserialize the object 
     *       when you using this constructor. Otheriwese the xml document would
     *       be null.
     *
     *
     * @param is The InputStream containing XML schema.
     */
    public DataSheetModel(InputStream is) {
        super(is);
    }
    
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // XML document methods
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    transient private EntityResolver entityResolver = null;
    
    public void setEntityResolver(EntityResolver er) {
        this.entityResolver = er;
    }
    
    public EntityResolver getEntityResolver() {
        return entityResolver;
    }
    
    protected void createDocument(InputStream is) 
        throws IllegalArgumentException {
        if (is == null) {
            throw new IllegalArgumentException("Invalid parameter: "+
                "The InputStream is null in CCPropertySheetModel.");
        }
        EntityResolver er = getEntityResolver();
        if (er == null)
            super.createDocument(is);
        else
            this.createDocument(is, er);
    }
    
    protected void createDocument(InputStream is, EntityResolver er)
	    throws IllegalArgumentException {
	if (is == null) {
	    throw new IllegalArgumentException("Invalid parameter.");
        }
        if (er == null) {
            super.createDocument(is);
            return;
        }

	// validate the given stream of xml and return the Document produced
	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	factory.setIgnoringElementContentWhitespace(true);
	factory.setValidating(true);

	try {
	    DocumentBuilder documentBuilder = factory.newDocumentBuilder();
	    documentBuilder.setEntityResolver(er);
	    documentBuilder.setErrorHandler(new DefaultHandler() {
		public void error(SAXParseException e) {
		    throw new IllegalArgumentException(e.getMessage());
		}
		public void fatalError(SAXParseException e) {
		    throw new IllegalArgumentException(e.getMessage());
		}
		public void warning(SAXParseException e) {
		    CCDebug.trace3(e.getMessage());
		}
	    });
	    document = documentBuilder.parse(is);
	} catch (IOException e) {
	    throw new IllegalArgumentException(e.getMessage());
	} catch (SAXException e) {
	    throw new IllegalArgumentException(e.getMessage());
	} catch (ParserConfigurationException e) {
	    throw new IllegalArgumentException(e.getMessage());
	}
    }
}
