/*
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.tools.admingui.util;

import java.security.NoSuchAlgorithmException;
import java.security.KeyManagementException;

import javax.net.ssl.HttpsURLConnection;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

import com.sun.appserv.management.client.TrustAnyTrustManager;


/**
 * This class trusts any server generated certifcate blindly to
 * handle ssl connection. We have commented out the code to generate
 * client certificate, and store server certificate in truststore during 
 * handshake. We use it if necessary later, right now we just trust it.
 */
public class JSSE {

   /* public String getHostFromCertificate() throws Exception {
        HttpsURLConnection https = getHttpsURLConnection();
        https.connect();
        //We don't have to do the following, may be we can getaway with just
        //accepting any server certificate.
        Certificate[] cert = https.getServerCertificates();
        generateTrustStore(cert[0]);
        String dn = getDistinguishedName(cert[0]);
        String hostName = getHostNameFromDN(dn);
        return hostName;
    }
    private void generateTrustStore(Certificate cert) throws Exception {
        File f = new File("certdb.jks");
        FileOutputStream fout = new FileOutputStream(f);
        KeyStore key = KeyStore.getInstance("JKS");//default is JKS
        key.load(null, null); //initialize keystore
        key.setCertificateEntry("s1as", cert);
        key.store(fout, new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'});
        System.setProperty("javax.net.ssl.trustStore", "out.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");

    }
    private String getDistinguishedName(Certificate cert) {
        String dn = ((X509Certificate)cert).getSubjectX500Principal().getName();
        return dn;
    }
    private String getHostNameFromDN(String dn) {
        StringTokenizer str = new StringTokenizer(dn, ",");
        String s = str.nextToken();
        return s.substring(s.indexOf("=")+1);
    }*/
    public static void trustAnyServerCertificate() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslc = SSLContext.getInstance("SSLv3");
        final X509TrustManager[] tms = TrustAnyTrustManager.getInstanceArray();
        sslc.init(null, tms, null);
        if (sslc != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslc.getSocketFactory());
        }
	if(HttpsURLConnection.getDefaultHostnameVerifier() instanceof AcceptAnyHostName) {
		return;
	}
        HostnameVerifier hv = new AcceptAnyHostName();
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    private static class AcceptAnyHostName implements HostnameVerifier{
		public boolean verify(String s, SSLSession ssl) {
			return true;
		}
	}


}
