/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.util.LogUtil;
import java.util.Map;
import java.util.List;
import java.util.logging.Level;

/**
 *
 */
public class DebugHandlers {

    /**
     *	This method writes the given value to stdout using System.out.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void println(RequestContext reqCtx, HandlerContext handlerCtx) {
        Level level = LogUtil.stringToLogLevel((String) handlerCtx.getInputValue(LEVEL));
        
	String label = (String)handlerCtx.getInputValue(LABEL);
	if (label == null) {
	    label = "";
	}
        
 	Object value = handlerCtx.getInputValue(VALUE);
        if (value == null) {
           LogUtil.log(level, label+"null");
        }
        else if (value instanceof List) {
            List l = (List)value;
            for (int i=0; i<l.size(); i++) {
                Object o = l.get(i);
                if (o == null) {
                    LogUtil.log(level, label+"null");
                } else {
                    LogUtil.log(level, label+o.toString());
                }
            }
        } else if (value instanceof Exception) {
             LogUtil.log(level, label+((Exception)value).getMessage());
        } else if (value != null) {
            LogUtil.log(level, label+value.toString());
        } 
    }

    /**
     *	Exception Log Handler -- This handler logs an exception to the LogFile.
     */
    public void logException(RequestContext ctx, HandlerContext handlerCtx) {
	Throwable ex = (Throwable)handlerCtx.getInputValue(EXCEPTION_TO_LOG);
	String logLevel = (String)handlerCtx.getInputValue(LEVEL);
        if (logLevel == null)
            logLevel = "FINE";
        Level level = LogUtil.stringToLogLevel(logLevel);
        
	if (ex != null) {
            LogUtil.log(level, "", ex);
	} else {
	    LogUtil.log(level, getClass().getName()+
		".logException() called without an exception to log.");
	}
    }

    public static final String VALUE =		"value";
    public static final String LABEL =		"label";
    public static final String LEVEL =		"level";
    public static final String EXCEPTION_TO_LOG = "exceptionToLog";
}
