/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.DefaultModel;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.model.ModelManager;

import java.util.Map;


/**
 *  This class defines both Source and Target mappings to and from a model.
 */
public class ModelHandlers {

    /**
     *	<p> Returns the Model from the Model Manager.</p>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getModel(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Pull out the required parameters
	Object classname = handlerCtx.getInputValue(MODEL_CLASS);
	if (classname == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a parameter named '"+
		MODEL_CLASS+"'!");
	}
    	Object instanceName = handlerCtx.getInputValue(INSTANCE_NAME);
	if (instanceName == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a parameter named '"+
		INSTANCE_NAME+"'!");
	}

	// Get the optional parameters...
	boolean fromSession = false;
	boolean toSession = false;
	Boolean boolValue = (Boolean)handlerCtx.getInputValue(FROM_SESSION);
	if (boolValue != null) {
	    fromSession = boolValue.booleanValue();
	}
	boolValue = (Boolean)handlerCtx.getInputValue(TO_SESSION);
	if (boolValue != null) {
	    toSession = boolValue.booleanValue();
	}

	// Get the model class
	if (!(classname instanceof Class)) {
	    try {
		classname = Class.forName(classname.toString());
	    } catch (ClassNotFoundException ex) {
		throw new RuntimeException(ex);
	    }
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE,
	    reqCtx.getModelManager().getModel(
		(Class)classname,
		instanceName.toString(),
		fromSession, toSession));
    }


    /**
     *	This target mapper saves a Model in the ModelManager
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void registerModel(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Get the instance name
    	Object instanceName = handlerCtx.getInputValue(INSTANCE_NAME);
	if (instanceName == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a parameter named '"+
		INSTANCE_NAME+"'!");
	}

	// Store the model in the ModelManager
	Model model = (Model)handlerCtx.getInputValue(MODEL);
	ModelManager modelManager = (ModelManager)reqCtx.getModelManager();
	modelManager.registerModel(instanceName.toString(), model);
    }


    /**
     *	<p> Returns the requested model value.</p>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getModelValue(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Make sure we got the key
    	Object key = handlerCtx.getInputValue(MODEL_KEY);
	if (key == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a parameter named '"+
		MODEL_KEY+"'!");
	}

	// First check to see if they supplied the Model itself
	Model model = (Model)handlerCtx.getInputValue(MODEL);
	if (model == null) {
	    // Try executing the getModel() handler and using its result
	    getModel(reqCtx, handlerCtx);
	    model = (Model)handlerCtx.getOutputValue(VALUE);
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE, model.getValue(key.toString()));
    }

    public void dumpModelValues(RequestContext reqCtx, HandlerContext handlerCtx) {
	Model model = (Model)handlerCtx.getInputValue(MODEL);
        if (model == null) {
            getModel(reqCtx, handlerCtx);
            model = (Model)handlerCtx.getOutputValue(VALUE);
        }
        if (model != null)
            ((DefaultModel)model).dumpValues(System.out);
    }
    
    /**
     *	This target mapper...
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void setModelValue(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Make sure we got the key
	Object key = handlerCtx.getInputValue(MODEL_KEY);
	if (key == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a parameter named '"+
		MODEL_KEY+"'!");
	}

	// Set the value
	Object value = handlerCtx.getInputValue(VALUE);
	Model model = (Model)handlerCtx.getInputValue(MODEL);
	if (model != null) {
	    // Set the Model value
	    model.setValue(key.toString(), value);
	    return;
	}

	// Try executing the getModel() handler and using its result
	getModel(reqCtx, handlerCtx);
	model = (Model)handlerCtx.getOutputValue(VALUE);
	model.setValue(key.toString(), value);
    }


    /**
     *
     */
    public static final String	VALUE =		"value";

    /**
     *	Parameter specifying whether to look in Session
     */
    public static final String	FROM_SESSION =	"modelFromSession";

    /**
     *	Parameter specifying whether to store in Session
     */
    public static final String	TO_SESSION =	"modelToSession";

    /**
     *	Parameter specifying the model class
     */
    public static final String	MODEL_CLASS =	"modelClass";

    /**
     *	Parameter specifying the model instance name
     */
    public static final String	INSTANCE_NAME =	"instanceName";

    /**
     *	The key used to retrieve a value from the model.
     */
    public static final String	MODEL_KEY =	"key";

    /**
     *	Parameter used to pass in a model to getModelValue
     */
    public static final String	MODEL =		"model";
}
