/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewManager;

import java.util.Iterator;
import java.util.List;
import java.util.Map;


/**
 *  This class defines both Source and Target mappings to and from a
 *  DisplayField.
 */
public class SessionHandlers {

    /**
     *	<p> This handler retrieves the requested page session value.  It
     *	    requires an input parameter named {@link #NAME} be provided to
     *	    specify the page session name.  You may optionally pass in the
     *	    <code>ViewBean</code> to use via the input parameter
     *	    {@link #VIEW_BEAN}.</p>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getPageSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(NAME);
	if (name == null) {
	    throw new FrameworkException("'"+NAME+
		"' specifying the PageSession name must be provided!");
	}

	ViewBean vb = (ViewBean)handlerCtx.getInputValue(VIEW_BEAN);
	if (vb == null) {
	    vb = getViewBean(reqCtx, handlerCtx);
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE, vb.getPageSessionAttribute(name));
    }


    /**
     *	<p> This is a helper method for obtaining a View.</p>
     */
    private ViewBean getViewBean(RequestContext reqCtx, HandlerContext handlerCtx) {
    	// Get the View ID
    	Object viewID = handlerCtx.getInputValue(VIEW_ID);
	if (viewID == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain "+VIEW_ID+"!");
	}

	// Try to obtain the ContainerView
	ViewBeanManager vm = reqCtx.getViewBeanManager();
	ViewBean vb = null;
	String topName = (viewID instanceof List) ?
	    ((List)viewID).get(0).toString() : viewID.toString();
	try {
	    vb = vm.getViewBean(topName);
	} catch (ClassCastException ex) {
	    vb = (ViewBean)((DescriptorViewManager)vm).getView(null, topName);
	} catch (ClassNotFoundException ex) {
	    throw new RuntimeException(ex);
	}
	if (vb == null) {
	    throw new RuntimeException(
		"Unable to obtain the view for mapping!");
	}

	// Set the output value
	return vb;
    }


    /**
     *	This method sets a DisplayField value.  "params" must contain the View
     *	key and the DisplayField name.  The key for the View is "viewID", the
     *	key for the DisplayField is "fieldName".  You may optionally specify
     *	that you want an array of values.  To do this, pass in the parameters
     *	"multiple" equal to "true".  Note, if you are obtaining a View (not a
     *	ViewBean), then the View must be cached in order for this to work
     *	correctly (the container will not get set correctly).  If you attmempt
     *	to set an array of values, but do not pass in an array type, an
     *	Object[] will be created with the value as its only emelent.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void setPageSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(NAME);
	if (name == null) {
	    throw new FrameworkException("'"+NAME+
		"' specifying the PageSession name must be provided!");
	}

	ViewBean vb = (ViewBean)handlerCtx.getInputValue(VIEW_BEAN);
	if (vb == null) {
	    vb = getViewBean(reqCtx, handlerCtx);
	}

	Object value = handlerCtx.getInputValue(VALUE);
        vb.setPageSessionAttribute(name, (java.io.Serializable)value);
    }


    /**
     *	<p> This method retrieves the value from session.  It requires that a
     *	    parameter named {@link #KEY} be passed in via the parameter Map.  It
     *	    sets the value of the session key in output parameter
     *	    {@link #VALUE}.</p>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
    	Object key = handlerCtx.getInputValue(KEY);
	if (key == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a key!");
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE,
	    reqCtx.getRequest().getSession().getAttribute(key.toString()));
    }


    /**
     *	This method stores the given value in session.  The key under which the
     *	value is to be stored must be specified in the parameter Map under KEY.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void setSessionValue(RequestContext reqCtx, HandlerContext handlerCtx) {
	Object value = handlerCtx.getInputValue(VALUE);
	Object key = handlerCtx.getInputValue(KEY);
	if (key == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a key!");
	}
	reqCtx.getRequest().getSession().setAttribute(key.toString(), value);
    }


    /**
     *	('viewBean').
     */
    public static final String	VIEW_BEAN =	"viewBean";

    /**
     *	('name').
     */
    public static final String	NAME =		"name";

    /**
     *	('viewID').
     */
    public static final String	VIEW_ID =	"viewID";

    /**
     *	('key').
     */
    public static final String	KEY =		"key";

    /**
     *	('value').
     */
    public static final String	VALUE =		"value";
}
