/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.exception;

import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;


/**
 *  This error is used to propagate errors that should be seen be the user.
 */
public class FrameworkError extends Error implements ViewDescriptorHolder {

    /**
     *
     */
    public FrameworkError() {
	super();
    }


    /**
     *
     */
    public FrameworkError(ViewDescriptor viewDesc, View view) {
	super();

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkError(Throwable ex) {
	super(ex);
    }


    /**
     *
     */
    public FrameworkError(Throwable ex, ViewDescriptor viewDesc, View view) {
	super(ex);

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkError(String msg) {
	super(msg);
    }


    /**
     *	This is the preferred constructor if there is no root cause.
     */
    public FrameworkError(String msg, ViewDescriptor viewDesc, View view) {
	super(msg);

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkError(String msg, Throwable ex) {
	super(msg, ex);
    }


    /**
     *	This is the preferred constructor.
     */
    public FrameworkError(String msg, Throwable ex, ViewDescriptor viewDesc, View view) {
	super(msg, ex);

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *	Allow the Error to hold the responsible View
     */
    public void setResponsibleView(View view) {
	_view = view;
    }


    /**
     *	Allow the Error to hold the responsible View
     */
    public View getResponsibleView() {
	return _view;
    }


    /**
     *	Allow the Error to hold the responsible ViewDescriptor
     */
    public void setResponsibleViewDescriptor(ViewDescriptor viewDesc) {
	_viewDesc = viewDesc;
    }


    /**
     *	Allow the responsible ViewDescriptor to be obtained.
     *
     *	@return The responsible ViewDescriptor (null if not specified)
     */
    public ViewDescriptor getResponsibleViewDescriptor() {
	return _viewDesc;
    }


    private View		_view		= null;
    private ViewDescriptor	_viewDesc	= null;
}
