/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.util.TypeConverter;

import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.IODescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.io.Serializable;
import java.util.EventObject;


/**
 *
 */
public class HandlerContextImpl implements HandlerContext {

    /**
     *	Constructor
     */
    protected HandlerContextImpl(UseHandlerDescriptor useHandler, HandlerDescriptor handler, View view, ViewDescriptor vd, EventObject event) {
	_eventObject = event;
	_useHandlerDesc = useHandler;
	_handlerDesc = handler;
	_view = view;
	_viewDesc = vd;
    }


    /**
     *	This returns the nearest View associated with the handler.
     */
    public View getView() {
	return _view;
    }


    /**
     *	This method returns the nearest ViewDescriptor associated with the
     *	handler.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
	/*
	if (_viewDesc != null) {
	    return _viewDesc;
	}

	// First find a DescriptorContainerView so we can get a ViewDescriptor
	View view = getView();
	View tmp = view;
	String lastName = "";
	while ((tmp != null) && !(tmp instanceof DescriptorContainerView)) {
	    lastName = tmp.getName();
	    tmp = tmp.getParent();
	}
	if (tmp == null) {
	    // Didn't find one, return null
	    return null;
	}

	// Pull off a ViewDescriptor
	_viewDesc = ((DescriptorContainerView)tmp).getViewDescriptor();

	// Unless we have a Descriptor for 'view', try the child descriptor
	if ((tmp != view) && (_viewDesc.getChildDescriptor(lastName) != null)) {
	    _viewDesc = _viewDesc.getChildDescriptor(lastName);
	}

	// Return the closest ViewDescriptor
	return _viewDesc;
	*/
    }


    /**
     *	This method returns the Event that caused the handler to be invoked.
     */
    public EventObject getEvent() {
	return _eventObject;
    }


    /**
     *	This method returns the UseHandlerDescriptor associated with the
     *	handler.  The UseHandlerDescriptor can be thought of the instance
     *	of the handler that is being invoked.  It contains the actual input
     *	parameters to sent to the handler (if any), and a reference to the
     *	handler definition (HandlerDescriptor).
     */
    public UseHandlerDescriptor getUseHandlerDescriptor() {
	return _useHandlerDesc;
    }


    /**
     *	This method returns the HandlerDescriptor associated with the handler.
     *	The handler descriptor can be thought of the definition to the handler
     *	itself.  It contains the method, I/O definition, and may also define
     *	other UseHandlers to be invoked prior to executing itself.
     */
    public HandlerDescriptor getHandlerDescriptor() {
	return _handlerDesc;
    }


    /**
     *	This method returns the input value for the given input name.  The name
     *	must be valid or an exception will be thrown.  This method WILL parse
     *	the value for "$()"; if you don't want this to happen, you can get the
     *	value directly from the UseHandlerDescriptor.
     */
    public Object getInputValue(String name) {
	// Make sure the requested name is valid
	IODescriptor inDesc = getHandlerDescriptor().getInputDescriptor(name);
	if (inDesc == null) {
	    throw new FrameworkException("Attempted to get input value '"+name+
		"', however, this is not a declared input parameter in "+
		"function '"+getHandlerDescriptor().getName()+"'!  Check your"+
		" handler and/or the XML (near ViewDescriptor '"+
		getViewDescriptor().getName()+"').", getViewDescriptor(),
		getView());
	}

	// Get the value, and parse it
	Object value = getUseHandlerDescriptor().getInputValue(name);
	if (value == null) {
	    value = inDesc.getDefault();
	}
	value = Util.replaceVariablesWithAttributes(value, getViewDescriptor());

	// Make sure the value is the correct type...
	value = TypeConverter.asType(inDesc.getType(), value);

	return value;
    }


    /**
     *	This method sets the specified output value.  The name must be valid or
     *	an exception will be thrown.  Output values are currently stored as
     *	request attributes.  The key will be the HandlerDescriptor's name +
     *	OUTPUT_VALUE_SEPARATOR + name (i.e. "handlerName.outputParamName").
     *
     *	@param	name	The name of the output variable
     *	@param	value	The value of the output variable (may be converted to
     *			the correct type if not already correct).
     */
    public void setOutputValue(String name, Object value) {
	// Make sure the requested name is valid
	HandlerDescriptor handler = getHandlerDescriptor();
	IODescriptor outDesc = handler.getOutputDescriptor(name);
	if (outDesc == null) {
	    throw new FrameworkException("Attempted to set output value '"+name+
		"' from handler '"+handler.getName()+"', however, this is not "+
		"a declared output parameter!  Check your handler and/or the "+
		"XML.", getViewDescriptor(), getView());
	}

	// Make sure the value is the correct type...
	value = TypeConverter.asType(outDesc.getType(), value);

	// Store the value as requested (or use default)
	String targetKey;
	String targetType;
	String outputParams[] = getUseHandlerDescriptor().getOutputMapping(name);
	if (outputParams == null) {
	    targetKey = handler.getName()+OUTPUT_VALUE_SEPARATOR+name;
	    targetType = ATTRIBUTE_TYPE;
	} else {
	    targetKey = outputParams[0];
	    if (targetKey == null) {
		targetKey = handler.getName()+OUTPUT_VALUE_SEPARATOR+name;
	    }
	    targetType = outputParams[1];
	    if (targetType == null) {
		targetType = ATTRIBUTE_TYPE;
	    }
	}
	if (targetType.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
	    RequestManager.getRequestContext().getRequest().
		setAttribute(targetKey, value);
	} else if (targetType.equalsIgnoreCase(SESSION_TYPE)) {
	    RequestManager.getRequestContext().getRequest().getSession().
		setAttribute(targetKey, value);
	} else if (targetType.equalsIgnoreCase(PAGE_SESSION_TYPE)) {
	    ViewBean vb = Util.getParentViewBean(getView());
	    vb.setPageSessionAttribute(targetKey, (Serializable)value);
	} else {
	    throw new FrameworkException("Invalid target type '"+targetKey+
		"' used for assigning output from function '"+
		handler.getName()+"'.", getViewDescriptor(), getView());
	}
    }


    /**
     *	This method retrieves an output value that has been set.
     */
    public Object getOutputValue(String name) {
	// Make sure the requested name is valid
	HandlerDescriptor handler = getHandlerDescriptor();
	IODescriptor outDesc = handler.getOutputDescriptor(name);
	if (outDesc == null) {
	    throw new FrameworkException("Attempted to get output value '"+name+
		"' from handler '"+handler.getName()+"', however, this is not "+
		"a declared output parameter!  Check your handler and/or the "+
		"XML.", getViewDescriptor(), getView());
	}

	// Find the targetKey/targetType (or use default)
	String targetKey;
	String targetType;
	String outputParams[] =
	    getUseHandlerDescriptor().getOutputMapping(name);
	if (outputParams == null) {
	    targetKey = handler.getName()+OUTPUT_VALUE_SEPARATOR+name;
	    targetType = ATTRIBUTE_TYPE;
	} else {
	    targetKey = outputParams[0];
	    if (targetKey == null) {
		targetKey = handler.getName()+OUTPUT_VALUE_SEPARATOR+name;
	    }
	    targetType = outputParams[1];
	    if (targetType == null) {
		targetType = ATTRIBUTE_TYPE;
	    }
	}

	// Get the requested output value
	Object value;
	if (targetType.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
	    value = RequestManager.getRequestContext().getRequest().
		getAttribute(targetKey);
	} else if (targetType.equalsIgnoreCase(SESSION_TYPE)) {
	    value = RequestManager.getRequestContext().getRequest().
		getSession().getAttribute(targetKey);
	} else if (targetType.equalsIgnoreCase(PAGE_SESSION_TYPE)) {
	    ViewBean vb = Util.getParentViewBean(getView());
	    value = vb.getPageSessionAttribute(targetKey);
	} else {
	    throw new FrameworkException("Invalid target type '"+targetKey+
		"' used for assigning output from function '"+
		handler.getName()+"'.", getViewDescriptor(), getView());
	}
	return value;
    }


    public static final String		OUTPUT_VALUE_SEPARATOR	=	".";
    public static final String		ATTRIBUTE_TYPE		=	"attribute";
    public static final String		SESSION_TYPE		=	"session";
    public static final String		PAGE_SESSION_TYPE	=	"pageSession";
    

    private EventObject			_eventObject	= null;
    private HandlerDescriptor		_handlerDesc	= null;
    private UseHandlerDescriptor	_useHandlerDesc = null;
    private View			_view		= null;
    private ViewDescriptor		_viewDesc	= null;
}
