/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.BasicTiledView;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.DescriptorCCActionTableTiledView;

import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.table.CCActionTable;


/**
 *  This Descriptor is used to create a TiledView that sits inside a
 *  CCActionTable.  This is required for input fields of the CCActionTable so
 *  that they have [x] in their qualified name (where 'x' is the row number).
 */
public class CCActionTableTiledDescriptor extends CCActionTableChildDescriptor {

    /**
     *	Constructor
     */
    public CCActionTableTiledDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method.  It will create a BasicTiledView and if the
     *	given container is a CCActionTable (it should be), it will invoke
     *	setTiledView() with the newly created BasicTiledView.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the newly created 
     *	@param	name		The Name of the View to be created.
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	BasicTiledView tiledView = new DescriptorCCActionTableTiledView(ctx, container, name, this, getModel());
	if (container instanceof CCActionTable) {
	    ((CCActionTable)container).setTiledView(tiledView);
	}
	return tiledView;
    }
}
