/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.sun.web.ui.view.html.CCButton;


/**
 *
 */
public class CCButtonDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCButtonDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method for CCButton instances.
     *
     *	@param	ctx	    The RequestContext
     *	@param	container   The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Create the button -- name is actually the value :(
        String buttonText = (String)getParameter("name");
	CCButton view =
	    new CCButton(container, name, getModelFieldName(), buttonText);

	// Set extra HTML if supplied...
	// JATO does not define setExtraHtml in HtmlDisplayField and Button
	// does not extend from HtmlDisplayFieldBase... this means I cannot
	// use this method... work-a-round is to pass in null and get the
	// return value and call the setter here (ugly!) (CR# 6175891)
	String extraHtml = setExtraHtml(null);
	if (extraHtml != null) {
	    view.setExtraHtml(extraHtml);
	}
        //boolean disabled = Boolean.parseBoolean((String)getParameter("disabled"));
        //view.setDisabled(disabled);
        
        view.setDisabled(isDisabled());
	return view;
    }

    public static final String EXTRA_HTML   =	"extraHtml";
}
