/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.SelectableGroupImpl;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import java.util.ArrayList;
import java.util.List;

/**
 *  Unfortunately, this class has to exist to support Lockhart tags.  They are
 *  not current with JATO and cannot use JATO BasicChoiceDisplayField's.  Once,
 *  Lockhart supports those fields, then this class will be deprecated in favor
 *  of ChoiceFieldDescriptor.
 */
public class SelectFieldDescriptor extends DisplayFieldDescriptor {

    /**
     *	This constructor creates a DisplayFieldDescriptor.  Name is
     *	required to create a SelectFieldDescriptor.
     *
     *	@param name		Instance name for the described SelectField
     */
    public SelectFieldDescriptor(String name) {
	super(name);
    }


    /**
     *
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	SelectableGroupImpl choice = new SelectableGroupImpl(
	    container, name, getModelFieldName(), getInitialValue());
        setOptions(choice);
	setExtraHtml(choice);
	return choice;
    }
    
    protected void setOptions(SelectableGroup choice) {
	Object options = getParameter(LABELS);
	if (options != null) {
	    if (options instanceof String) {
		List tmp = new ArrayList();
		tmp.add(options);
		options = tmp;
	    }
	    List optionList = (List)options;
	    int numOptions = optionList.size();

	    Object values = getParameter(VALUES);
	    List valueList = optionList;
	    if (values != null) {
		if (values instanceof String) {
		    List tmp = new ArrayList();
		    tmp.add(values);
		    values = tmp;
		}
		valueList = (List)values;
		if (valueList.size() != numOptions) {
		    throw new FrameworkException(
			"Unequal number of option names / values!",
			this, choice.getParent());
		}
	    }

	    OptionList choices =
		new OptionList(
		    (String [])optionList.toArray(new String[numOptions]),
		    (String [])valueList.toArray(new String[numOptions]));
	    choice.setOptions(choices);
	}
    }


    /**
     *	OPTIONS are the 
     */
    public static final String	LABELS	= "labels";
    public static final String	VALUES	= "values";
}
