/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.event;

import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.EventObject;


/**
 *  This event object will be created and used immediately after the child is
 *  created.  This is useful if you need to init something, but the
 *  initialization depends on the object being created.  This event is invoked
 *  for either the submit cycle or the display cycle whichever causes the View
 *  to be created.  The source for this event will be the View created.
 */
public class AfterCreateEvent extends EventObject {

    /**
     *	This is the constructor for a AfterCreateEvent.  You must specify the
     *	ViewDescriptor (the ViewDescriptor of the View that was just created).
     *	The src argument should be the View that was just created.
     *
     *	@param	src	The containing View
     *	@param	desc	The ViewDescriptor for the View to be created
     */
    public AfterCreateEvent(View src, ViewDescriptor desc) {
	super(src);
	setViewDescriptor(desc);
    }


    /**
     *	This method sets the ViewDescriptor for the View that was just created.
     *
     *	@param	viewDesc	The ViewDescriptor of the View to be created.
     */
    protected void setViewDescriptor(ViewDescriptor viewDesc) {
	if (viewDesc == null) {
	    throw new IllegalArgumentException(
		"You must specify a ViewDescriptor when creating a "+
		"AfterCreateEvent object!");
	}
	_viewDesc = viewDesc;
    }


    /**
     *	This method retrieves the ViewDescriptor of the View that was just
     *	created.  The ViewDescriptor may have necessary information in order to
     *	do what you have to do after the View is created.
     *
     *	@return The ViewDescriptor for the View that was just created.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }


    /**
     *	This method returns the name of the View that was just created.
     *
     *	@return The name of the view that was created.
     */
    public String getName() {
	return getViewDescriptor().getName();
    }


    private ViewDescriptor _viewDesc = null;
}
