/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * BackupWarningException.java
 *
 * Created on April 1, 2004, 6:23 PM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.util.StringUtils;

/**
 *
 * @author  bnevins
 * Problem -- some "errors" should not be handled by CLI as "errors", but as warnings.
 * However, the Exception throwing mechanism is the non-kludgiest way to get the
 * message back to the command handler in CLI.
 * Thus this class.
 */
public class BackupWarningException extends BackupException
{
	/**
	 * Constructs a BackupWarningException with a possibly i18n'd detail message.
	 * @param s the detail message which is first checked for as a key for an i18n string.  
	 * If not found it will be used as the message itself.
	 */	
	public BackupWarningException(String s)
	{
		super(s);
	}
	
	/**
	 * @param s the detail message which is first checked for as a key for an i18n string.  
	 * If not found it will be used as the message itself.
	 * @param o the parameter for the recovered i18n string. I.e. "{0}" will be
	 * replaced with o.toString().  If there is no i18n string located
	 * o will be ignored.
	 */	
	public BackupWarningException(String s, Object o)
	{
		super(s, o);
	}
}
