/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.helper.RefHelper;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.config.AMXConfigImplBase;




/**
*/
public final class DomainConfigImpl extends AMXConfigImplBase
	implements ConfigFactoryCallback
	// implements DomainConfig
{
		public
	DomainConfigImpl( Delegate	delegate )
	{
		super( delegate );
	}


	private static final Set<String> NOT_SUPERFLUOUS =
	    GSetUtil.newUnmodifiableStringSet(
    	    "getServerConfigObjectNameMap"
        );
            
	    protected final Set<String>
	getNotSuperfluousMethods()
	{
	    return GSetUtil.newSet( super.getNotSuperfluousMethods(), NOT_SUPERFLUOUS );
	}
	
		public Map<String,ObjectName>
	getServerConfigObjectNameMap()
	{
		final Map<String,StandaloneServerConfig> m1	=
		    ((DomainConfig)getSelf()).getStandaloneServerConfigMap();
		final Map<String,ClusteredServerConfig> m2	=
		    ((DomainConfig)getSelf()).getClusteredServerConfigMap();
		
		final Map<String,ObjectName> allObjectNames   = Util.toObjectNames( m1 );
		allObjectNames.putAll( Util.toObjectNames( m2 ) );

        return allObjectNames;
	}
}































