/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.config.SSLConfigKeys;

import com.sun.appserv.management.util.misc.GSetUtil;

/**
 */
class SSLConfigFactory extends ConfigFactory
{
    private static final String CREATE_SSL  = "createSsl";
    private static final String[] CREATE_SSL_SIG  = new String[] { AttributeList.class.getName() };
    
    private static final String REMOVE_SSL  = "removeSsl";
    private static final String[] REMOVE_SSL_SIG  = null;
	
		public
	SSLConfigFactory(final ConfigFactoryCallback	callbacks)
	{
		super( callbacks );
	}
	
	/**
	 */
	private static final String	CERT_NICKNAME_KEY		= "cert-nickname";
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
    		SSLConfigKeys.CLIENT_AUTH_ENABLED_KEY,
    		SSLConfigKeys.SSL_2_CIPHERS_KEY,
    		SSLConfigKeys.SSL_3_TLS_CIPHERS_KEY,
    		SSLConfigKeys.SSL_3_ENABLED_KEY,
    		SSLConfigKeys.SSL_2_ENABLED_KEY,
    		SSLConfigKeys.TLS_ENABLED_KEY,
    		SSLConfigKeys.TLS_ROLLBACK_ENABLED_KEY,
    		SSLConfigKeys.SSL3_TLS_CIPHERS_KEY
    );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
	private final static Map<String,String>	OVERRIDES	=
	    Collections.unmodifiableMap( MapUtil.newMap(
		new String[]
		{
			CONFIG_NAME_KEY, CERT_NICKNAME_KEY,
		}
		));
		
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( OVERRIDES );
	}

	
		public ObjectName
	create(
		final String	            certNickname,
		final Map<String,String>	optional )
	{
		final Map<String,String> params = initParams( certNickname, null, optional );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}
	
		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
	    final ObjectName oldObjectName = (ObjectName)
	        getCallbacks().getDelegate().invoke(
	            CREATE_SSL, new Object[] { attrs }, CREATE_SSL_SIG );
		
		return oldObjectName;
	}
	
		public void
	internalRemove( final ObjectName sslConfigObjectName )
	{
	    getCallbacks().getDelegate().invoke( REMOVE_SSL, null, REMOVE_SSL_SIG );
		getCallbacks().sendConfigRemovedNotification( sslConfigObjectName );
	}
}






