/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 */


package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;

import javax.management.AttributeList;
import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ServerRefConfigCR;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.LBConfig;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.support.oldconfig.OldLbConfig;
import com.sun.enterprise.management.support.oldconfig.OldClusterMBean;
import com.sun.enterprise.management.support.oldconfig.OldCreateRemoveServerRef;


final class ServerRefConfigFactory extends ConfigFactory
{
    public ServerRefConfigFactory(final ConfigFactoryCallback callbacks)
    {
        super( callbacks );
	}
                
        protected Map<String,String> 
	getParamNameOverrides()
	{
		return( MapUtil.newMap( CONFIG_NAME_KEY, "ref" ) );
	}

    private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		        ServerRefConfigCR.DISABLE_TIMEOUT_IN_MINUTES_KEY,
                ServerRefConfigCR.LB_ENABLED_KEY,
                ServerRefConfigCR.ENABLED_KEY );

        protected Set<String> getLegalOptionalCreateKeys() {
		return( LEGAL_OPTIONAL_KEYS );
	}
        
        private OldCreateRemoveServerRef
    getOldCreateRemoveServerRef()
    {
        final ServerRefConfigCR     fc  = (ServerRefConfigCR)getFactoryContainer();
        final String                name = Util.asAMX( fc ).getName();
        
        OldCreateRemoveServerRef    result  = null;
        if ( fc instanceof ClusterConfig )
        {
            result  = getOldConfigProxies().getOldClusterMBean( name );
        }
        else if ( fc instanceof LBConfig )
        {
            result  = getOldConfigProxies().getOldLbConfig( name );
        }
        
        return result;
    }
    
		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		return getOldCreateRemoveServerRef().createServerRef(translatedAttrs);
	}

		public ObjectName
	create(
		final String referencedServerName, 
		final Map<String,String> optional)
	{
		final String[] requiredParams = new String[] {};

		final Map<String,String> params =
		    initParams(referencedServerName,  requiredParams, optional);

		final ObjectName amxName = createNamedChild(referencedServerName, params );

		return( amxName );                
	}

		public ObjectName
	create(
		final String referencedServerName, 
		final String disableTimeoutInMinutes,
		final boolean lbEnabled, 
		final boolean enabled)
	{
		final Map<String,String> optionalParams = new java.util.HashMap<String,String>();
		optionalParams.put( ServerRefConfigCR.DISABLE_TIMEOUT_IN_MINUTES_KEY,disableTimeoutInMinutes); 
		optionalParams.put( ServerRefConfigCR.LB_ENABLED_KEY,Boolean.toString(lbEnabled)); 
		optionalParams.put( ServerRefConfigCR.ENABLED_KEY,Boolean.toString(enabled)); 

		return create(referencedServerName, optionalParams);
	}

	public void removeByName(final String referencedServerName)
	{
		getOldCreateRemoveServerRef().removeServerRefByRef(referencedServerName);
	}
}



